/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.LexoRankManager;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.issue.AbstractIssueEventListener;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LexoRankIssueEventListener
extends AbstractIssueEventListener {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private LexoRankManager lexoRankManager;

    @Override
    protected void doOnIssueEvent(Long typeId, Issue issue, IssueEvent event) {
        ServiceOutcome<Void> clearOutcome;
        if (EventType.ISSUE_DELETED_ID.equals(typeId) && (clearOutcome = this.lexoRankManager.deleteRanksForDeletedIssue(issue.getId())).isInvalid()) {
            this.log.warn("Unable to delete ranking for issue with id[%d]", issue.getId());
            this.log.warn(clearOutcome.getErrors());
        }
    }
}

