/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRow;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.lexorank.LexoRankOperationOutcome;
import com.atlassian.greenhopper.service.lexorank.LexoRankStatisticsAgent;
import com.atlassian.jira.exception.DataAccessException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LexoRankHealOperation {
    private static final LoggerWrapper LOG = LoggerWrapper.with(LexoRankHealOperation.class);
    private final LexoRankDao dao;
    private final LexoRankStatisticsAgent statisticsAgent;
    private final Long rankFieldId;
    private final List<LexoRankRow> rowsToHeal;

    private LexoRankHealOperation(LexoRankDao dao, LexoRankStatisticsAgent statisticsAgent, Long rankFieldId, List<LexoRankRow> rowsToHeal) {
        this.dao = dao;
        this.statisticsAgent = statisticsAgent;
        this.rankFieldId = rankFieldId;
        this.rowsToHeal = rowsToHeal;
    }

    public static ForRankField builder(LexoRankDao lexoRankDao, LexoRankStatisticsAgent lexoRankStatisticsAgent) {
        return new Builder(lexoRankDao, lexoRankStatisticsAgent);
    }

    public LexoRankOperationOutcome<Boolean> execute() {
        boolean containsDuplicateValues = false;
        ArrayList healedIssueIds = Lists.newArrayList();
        HashMap<String, LexoRankRow> lexoRankRowByRankMap = new HashMap<String, LexoRankRow>();
        LOG.debug("Executing heal operation on the following rows: %s", this.rowsToHeal);
        for (LexoRankRow lexoRankRow : this.rowsToHeal) {
            if (lexoRankRowByRankMap.containsKey(lexoRankRow.getRank())) {
                LexoRankRow firstLexoRankRow = (LexoRankRow)lexoRankRowByRankMap.get(lexoRankRow.getRank());
                if (firstLexoRankRow.getId().equals(lexoRankRow.getId())) continue;
                containsDuplicateValues = true;
                LexoRankRow fixedLexoRankRow = this.performHeal(firstLexoRankRow, lexoRankRow);
                lexoRankRowByRankMap.put(fixedLexoRankRow.getRank(), fixedLexoRankRow);
                healedIssueIds.add(fixedLexoRankRow.getIssueId());
                continue;
            }
            lexoRankRowByRankMap.put(lexoRankRow.getRank(), lexoRankRow);
        }
        return LexoRankOperationOutcome.ok(Boolean.valueOf(containsDuplicateValues), healedIssueIds);
    }

    private LexoRankRow performHeal(LexoRankRow firstRow, LexoRankRow duplicateRow) {
        this.statisticsAgent.startOperationStep(LexoRankStatisticsAgent.OperationStep.HEAL_RANKVALUE);
        LOG.info("Fixing duplicate rank values (id=" + firstRow.getId() + ",rank=" + firstRow.getRank() + "),(id=" + duplicateRow.getId() + ",rank=" + duplicateRow.getRank() + ")", new Object[0]);
        LOG.debug("First RankRow     : " + firstRow.toString(), new Object[0]);
        LOG.debug("Duplicate RankRow : " + duplicateRow.toString(), new Object[0]);
        LexoRankRow nextRow = this.dao.findNextOneByRank(this.rankFieldId, firstRow.getRank());
        LOG.debug("Inserting duplicate row between first row and row: %s", nextRow);
        LexoRank rankBetweenFrom = LexoRank.parse(firstRow.getRank());
        LexoRank rankBetweenTo = LexoRank.parse(nextRow.getRank());
        LexoRank newRank = rankBetweenFrom.getBucket().equals((Object)rankBetweenTo.getBucket()) ? rankBetweenFrom.between(rankBetweenTo) : rankBetweenFrom.genNext();
        String newRankStr = newRank.format();
        LOG.debug("Setting rank of duplicate row to be %s (was: %s)", newRankStr, duplicateRow.getRank());
        duplicateRow.setRank(newRankStr);
        ServiceOutcome<LexoRankRow> saveResult = this.dao.unlockedSave(duplicateRow);
        if (saveResult.isInvalid()) {
            LOG.error(saveResult.getErrors());
            throw new DataAccessException("Failed to save rank change for duplicate row: " + duplicateRow);
        }
        LOG.info("Duplicate rank values fixed (id=" + duplicateRow.getId() + ",rank=" + duplicateRow.getRank() + ")", new Object[0]);
        this.statisticsAgent.endOperationStep(LexoRankStatisticsAgent.OperationStep.HEAL_RANKVALUE);
        return duplicateRow;
    }

    public static interface CompleteHealOperation {
        public LexoRankHealOperation build();
    }

    public static interface RowsToHeal {
        public CompleteHealOperation heal(LexoRankRow ... var1);
    }

    public static interface ForRankField {
        public RowsToHeal forRankField(Long var1);
    }

    private static class Builder
    implements ForRankField,
    RowsToHeal,
    CompleteHealOperation {
        private LexoRankDao lexoRankDao;
        private LexoRankStatisticsAgent lexoRankStatisticsAgent;
        private Long rankFieldId;
        private List<LexoRankRow> rowsToHeal;

        private Builder(LexoRankDao lexoRankDao, LexoRankStatisticsAgent lexoRankStatisticsAgent) {
            this.lexoRankDao = lexoRankDao;
            this.lexoRankStatisticsAgent = lexoRankStatisticsAgent;
        }

        @Override
        public LexoRankHealOperation build() {
            return new LexoRankHealOperation(this.lexoRankDao, this.lexoRankStatisticsAgent, this.rankFieldId, this.rowsToHeal);
        }

        @Override
        public RowsToHeal forRankField(Long rankFieldId) {
            this.rankFieldId = rankFieldId;
            return this;
        }

        @Override
        public CompleteHealOperation heal(LexoRankRow ... rowsToHeal) {
            this.rowsToHeal = Lists.newArrayList((Object[])rowsToHeal);
            return this;
        }
    }
}

