/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank;

import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRow;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRowUtils;
import com.atlassian.greenhopper.manager.lexorank.lock.Lock;
import com.atlassian.greenhopper.manager.lexorank.lock.LockOutcome;
import com.atlassian.greenhopper.manager.lexorank.lock.LockProcessOutcome;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.lexorank.BackoffHandler;
import com.atlassian.greenhopper.service.lexorank.LexoRankOperationOutcome;
import com.atlassian.greenhopper.service.lexorank.LexoRankSettings;
import com.atlassian.greenhopper.service.lexorank.LexoRankStatisticsAgent;
import com.google.common.collect.Lists;

public class LexoRankDeleteOperation {
    private LexoRankDao lexoRankDao;
    private LexoRankStatisticsAgent lexoRankStatisticsAgent;
    private DeleteOperationType deleteOperationType;
    private Long objectTypeId;

    private LexoRankDeleteOperation(LexoRankDao lexoRankDao, LexoRankStatisticsAgent lexoRankStatisticsAgent, DeleteOperationType deleteOperationType, Long objectTypeId) {
        this.lexoRankDao = lexoRankDao;
        this.lexoRankStatisticsAgent = lexoRankStatisticsAgent;
        this.deleteOperationType = deleteOperationType;
        this.objectTypeId = objectTypeId;
    }

    public static ForIssueOrRankField builder(LexoRankDao lexoRankDao, LexoRankStatisticsAgent lexoRankStatisticsAgent) {
        return new Builder(lexoRankDao, lexoRankStatisticsAgent);
    }

    public LexoRankOperationOutcome<Void> execute() {
        this.lexoRankStatisticsAgent.startOperation(LexoRankStatisticsAgent.Operation.DELETE_RANK_FOR_ISSUE);
        LexoRankOperationOutcome<Void> deleteOperationOutcome = null;
        switch (this.deleteOperationType) {
            case ISSUE: {
                deleteOperationOutcome = this.deleteRanksForIssue(this.objectTypeId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported delete operation type");
            }
        }
        this.lexoRankStatisticsAgent.endOperation(LexoRankStatisticsAgent.Operation.DELETE_RANK_FOR_ISSUE);
        return deleteOperationOutcome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LexoRankOperationOutcome<Void> deleteRanksForIssue(long issueId) {
        long timeoutTime = System.currentTimeMillis() + (long)LexoRankSettings.RANK_RETRY_TIMEOUT_MS;
        BackoffHandler backoffHandler = new BackoffHandler(this.lexoRankStatisticsAgent, timeoutTime);
        while (System.currentTimeMillis() < timeoutTime) {
            backoffHandler.maybeWait();
            LexoRankRow[] unlockedRows = this.lexoRankDao.findByIssueId(issueId);
            LockOutcome lockOutcome = this.lexoRankDao.acquireLock(unlockedRows);
            Lock lock = lockOutcome.get();
            if (!lockOutcome.isValid()) {
                if (lock == null) continue;
                this.lexoRankDao.releaseLock(lock);
                continue;
            }
            try {
                LockProcessOutcome<ServiceOutcome<Void>> deleteProcessOutcome;
                LexoRankRow[] lockedRows = this.lexoRankDao.findByIssueId(issueId);
                if (LexoRankRowUtils.areRowsDifferent(lockedRows, unlockedRows) || (deleteProcessOutcome = this.lexoRankDao.deleteByIssueId(lock, issueId)).isRetry()) continue;
                ServiceOutcome<Void> deleteOutcome = deleteProcessOutcome.get();
                if (deleteOutcome.isInvalid()) {
                    LexoRankOperationOutcome<Void> lexoRankOperationOutcome = LexoRankOperationOutcome.error(deleteOutcome.getErrors());
                    return lexoRankOperationOutcome;
                }
                LexoRankOperationOutcome<Object> lexoRankOperationOutcome = LexoRankOperationOutcome.ok(null, Lists.newArrayList((Object[])new Long[]{issueId}));
                return lexoRankOperationOutcome;
            }
            finally {
                this.lexoRankDao.releaseLock(lock);
            }
        }
        return LexoRankOperationOutcome.timeout();
    }

    public static interface CompleteDeleteOperation {
        public LexoRankDeleteOperation build();
    }

    public static interface ForIssueOrRankField {
        public CompleteDeleteOperation forIssue(Long var1);

        public CompleteDeleteOperation forRankField(Long var1);
    }

    private static class Builder
    implements ForIssueOrRankField,
    CompleteDeleteOperation {
        private LexoRankDao lexoRankDao;
        private LexoRankStatisticsAgent lexoRankStatisticsAgent;
        private DeleteOperationType deleteOperationType;
        private Long objectTypeId;

        private Builder(LexoRankDao lexoRankDao, LexoRankStatisticsAgent lexoRankStatisticsAgent) {
            this.lexoRankDao = lexoRankDao;
            this.lexoRankStatisticsAgent = lexoRankStatisticsAgent;
        }

        @Override
        public CompleteDeleteOperation forIssue(Long issueId) {
            this.deleteOperationType = DeleteOperationType.ISSUE;
            this.objectTypeId = issueId;
            return this;
        }

        @Override
        public CompleteDeleteOperation forRankField(Long rankFieldId) {
            this.deleteOperationType = DeleteOperationType.RANK_FIELD;
            this.objectTypeId = rankFieldId;
            return this;
        }

        @Override
        public LexoRankDeleteOperation build() {
            return new LexoRankDeleteOperation(this.lexoRankDao, this.lexoRankStatisticsAgent, this.deleteOperationType, this.objectTypeId);
        }
    }

    private static enum DeleteOperationType {
        ISSUE,
        RANK_FIELD;

    }
}

