/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank;

import com.atlassian.greenhopper.api.rank.RankChange;
import com.atlassian.greenhopper.model.lexorank.LexoRank;

public class LexoRankChange
implements RankChange {
    private final long customFieldId;
    private final long issueId;
    private final LexoRank oldRank;
    private final LexoRank newRank;

    private LexoRankChange(long customFieldId, long issueId, LexoRank oldRank, LexoRank newRank) {
        this.customFieldId = customFieldId;
        this.issueId = issueId;
        this.oldRank = oldRank;
        this.newRank = newRank;
    }

    public static ForRankField builder() {
        return new Builder();
    }

    @Override
    public boolean wasChanged() {
        return this.oldRank == null && this.newRank != null || this.oldRank != null && !this.oldRank.equals(this.newRank);
    }

    @Override
    public long getCustomFieldId() {
        return this.customFieldId;
    }

    @Override
    public long getIssueId() {
        return this.issueId;
    }

    public LexoRank getOldRank() {
        return this.oldRank;
    }

    public LexoRank getNewRank() {
        return this.newRank;
    }

    public String toString() {
        return "LexoRankChange(customFieldId=" + this.customFieldId + ",issueId=" + this.issueId + ",oldRank" + this.oldRank + ",newRank=" + this.newRank + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LexoRankChange that = (LexoRankChange)o;
        if (this.customFieldId != that.customFieldId) {
            return false;
        }
        if (this.issueId != that.issueId) {
            return false;
        }
        if (!this.oldRank.equals(that.oldRank)) {
            return false;
        }
        return this.newRank.equals(that.newRank);
    }

    public int hashCode() {
        int result = (int)(this.customFieldId ^ this.customFieldId >>> 32);
        result = 31 * result + (int)(this.issueId ^ this.issueId >>> 32);
        result = 31 * result + this.oldRank.hashCode();
        result = 31 * result + this.newRank.hashCode();
        return result;
    }

    public static interface CompleteLexoRankChange {
        public LexoRankChange build();
    }

    public static interface RankedTo {
        public CompleteLexoRankChange to(LexoRank var1);
    }

    public static interface NoRankChange {
        public CompleteLexoRankChange noop(LexoRank var1);
    }

    public static interface RankedInitially {
        public CompleteLexoRankChange initially(LexoRank var1);
    }

    public static interface RankedFrom
    extends RankedInitially,
    NoRankChange {
        public RankedTo from(LexoRank var1);
    }

    public static interface RankedIssue {
        public RankedFrom rankedIssue(Long var1);
    }

    public static interface ForRankField {
        public RankedIssue forRankField(Long var1);
    }

    private static class Builder
    implements ForRankField,
    RankedIssue,
    RankedFrom,
    RankedTo,
    CompleteLexoRankChange {
        private long rankFieldId;
        private long issueId;
        private LexoRank oldRank;
        private LexoRank newRank;

        private Builder() {
        }

        @Override
        public LexoRankChange build() {
            return new LexoRankChange(this.rankFieldId, this.issueId, this.oldRank, this.newRank);
        }

        @Override
        public RankedIssue forRankField(Long rankFieldId) {
            this.rankFieldId = rankFieldId;
            return this;
        }

        @Override
        public RankedTo from(LexoRank oldRank) {
            this.oldRank = oldRank;
            return this;
        }

        @Override
        public CompleteLexoRankChange initially(LexoRank newRank) {
            this.oldRank = null;
            this.newRank = newRank;
            return this;
        }

        @Override
        public CompleteLexoRankChange noop(LexoRank existingRank) {
            this.oldRank = existingRank;
            this.newRank = existingRank;
            return this;
        }

        @Override
        public RankedFrom rankedIssue(Long issueId) {
            this.issueId = issueId;
            return this;
        }

        @Override
        public CompleteLexoRankChange to(LexoRank newRank) {
            this.newRank = newRank;
            return this;
        }
    }
}

