/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank;

import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRow;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRowUtils;
import com.atlassian.greenhopper.manager.lexorank.lock.Lock;
import com.atlassian.greenhopper.manager.lexorank.lock.LockOutcome;
import com.atlassian.greenhopper.manager.lexorank.lock.LockProcessOutcome;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.lexorank.BackoffHandler;
import com.atlassian.greenhopper.service.lexorank.LexoRankOperationOutcome;
import com.atlassian.greenhopper.service.lexorank.LexoRankSettings;
import com.atlassian.greenhopper.service.lexorank.LexoRankStatisticsAgent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

public class LexoRankBulkDeleteOperation {
    private static final int DELETE_BATCH_SIZE = 10;
    private LexoRankDao lexoRankDao;
    private LexoRankStatisticsAgent lexoRankStatisticsAgent;
    private ImmutableList<Long> issueIds;

    private LexoRankBulkDeleteOperation(LexoRankDao lexoRankDao, LexoRankStatisticsAgent lexoRankStatisticsAgent, ImmutableList<Long> issueIds) {
        this.lexoRankDao = lexoRankDao;
        this.lexoRankStatisticsAgent = lexoRankStatisticsAgent;
        this.issueIds = issueIds;
    }

    public static ForIssueOrRankField builder(LexoRankDao lexoRankDao, LexoRankStatisticsAgent lexoRankStatisticsAgent) {
        return new Builder(lexoRankDao, lexoRankStatisticsAgent);
    }

    public LexoRankOperationOutcome<Void> execute() {
        this.lexoRankStatisticsAgent.startOperation(LexoRankStatisticsAgent.Operation.DELETE_RANKS_FOR_ISSUES);
        LexoRankOperationOutcome<Void> deleteOperationOutcome = this.deleteRanksForIssues((List<Long>)this.issueIds);
        this.lexoRankStatisticsAgent.endOperation(LexoRankStatisticsAgent.Operation.DELETE_RANKS_FOR_ISSUES);
        return deleteOperationOutcome;
    }

    private LexoRankOperationOutcome<Void> deleteRanksForIssues(List<Long> issueIds) {
        for (List partition : Iterables.partition(issueIds, (int)10)) {
            LexoRankOperationOutcome<Void> outcome = this.deleteRanksForIssuesInBatch(partition);
            if (!outcome.isInvalid()) continue;
            return outcome;
        }
        return LexoRankOperationOutcome.ok(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LexoRankOperationOutcome<Void> deleteRanksForIssuesInBatch(List<Long> issueIds) {
        long timeoutTime = System.currentTimeMillis() + (long)LexoRankSettings.BATCH_DELETE_RETRY_TIMEOUT_MS;
        BackoffHandler backoffHandler = new BackoffHandler(this.lexoRankStatisticsAgent, timeoutTime);
        while (System.currentTimeMillis() < timeoutTime) {
            backoffHandler.maybeWait();
            LexoRankRow[] unlockedRows = this.lexoRankDao.findByIssueIds(issueIds);
            if (unlockedRows.length == 0) {
                return LexoRankOperationOutcome.ok(null);
            }
            LockOutcome lockOutcome = this.lexoRankDao.acquireLock(unlockedRows);
            Lock lock = lockOutcome.get();
            if (!lockOutcome.isValid()) {
                if (lock == null) continue;
                this.lexoRankDao.releaseLock(lock);
                continue;
            }
            try {
                LockProcessOutcome<ServiceOutcome<Void>> deleteProcessOutcome;
                LexoRankRow[] lockedRows = this.lexoRankDao.findByIssueIds(issueIds);
                if (LexoRankRowUtils.areRowsDifferent(lockedRows, unlockedRows) || (deleteProcessOutcome = this.lexoRankDao.deleteByLimitedIssueIds(lock, issueIds)).isRetry()) continue;
                ServiceOutcome<Void> deleteOutcome = deleteProcessOutcome.get();
                if (deleteOutcome.isInvalid()) {
                    LexoRankOperationOutcome<Void> lexoRankOperationOutcome = LexoRankOperationOutcome.error(deleteOutcome.getErrors());
                    return lexoRankOperationOutcome;
                }
                LexoRankOperationOutcome<Object> lexoRankOperationOutcome = LexoRankOperationOutcome.ok(null, issueIds);
                return lexoRankOperationOutcome;
            }
            finally {
                this.lexoRankDao.releaseLock(lock);
            }
        }
        return LexoRankOperationOutcome.timeout();
    }

    public static interface CompleteDeleteOperation {
        public LexoRankBulkDeleteOperation build();
    }

    public static interface ForIssueOrRankField {
        public CompleteDeleteOperation forIssues(Iterable<Long> var1);
    }

    private static class Builder
    implements ForIssueOrRankField,
    CompleteDeleteOperation {
        private LexoRankDao lexoRankDao;
        private LexoRankStatisticsAgent lexoRankStatisticsAgent;
        private ImmutableList<Long> issueIds;

        private Builder(LexoRankDao lexoRankDao, LexoRankStatisticsAgent lexoRankStatisticsAgent) {
            this.lexoRankDao = lexoRankDao;
            this.lexoRankStatisticsAgent = lexoRankStatisticsAgent;
        }

        @Override
        public CompleteDeleteOperation forIssues(Iterable<Long> issueIds) {
            this.issueIds = ImmutableList.copyOf(issueIds);
            return this;
        }

        @Override
        public LexoRankBulkDeleteOperation build() {
            return new LexoRankBulkDeleteOperation(this.lexoRankDao, this.lexoRankStatisticsAgent, this.issueIds);
        }
    }
}

