/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.lexorank;

import com.atlassian.greenhopper.service.lexorank.LexoRankStatisticsAgent;
import com.google.common.annotations.VisibleForTesting;
import java.security.SecureRandom;

public class BackoffHandler {
    static final String JIRA_DISABLE_LEXORANK_OPTIMIZATIONS = "jira.disable.lexorank.optimizations";
    private int numRetries = 0;
    private long sleepTime = 0L;
    private final long timeoutTime;
    private final LexoRankStatisticsAgent lexoRankStatisticsAgent;
    private final SleepStrategy sleepStrategy;
    static final SecureRandom rand = new SecureRandom();

    public BackoffHandler(LexoRankStatisticsAgent lexoRankStatisticsAgent, long timeoutTime) {
        this.timeoutTime = timeoutTime;
        this.lexoRankStatisticsAgent = lexoRankStatisticsAgent;
        this.sleepStrategy = this.createSleepStrategy();
    }

    public void maybeWait() {
        this.sleepStrategy.backoff();
    }

    @VisibleForTesting
    SleepStrategy getSleepStrategy() {
        return this.sleepStrategy;
    }

    private SleepStrategy createSleepStrategy() {
        if (System.getProperty(JIRA_DISABLE_LEXORANK_OPTIMIZATIONS) == null || "false".equals(System.getProperty(JIRA_DISABLE_LEXORANK_OPTIMIZATIONS))) {
            return new AggresiveSleepStrategy();
        }
        return new LegacySleepStrategy();
    }

    class AggresiveSleepStrategy
    implements SleepStrategy {
        AggresiveSleepStrategy() {
        }

        @Override
        public void backoff() {
            if (BackoffHandler.this.numRetries != 0) {
                BackoffHandler.this.lexoRankStatisticsAgent.startOperationStep(LexoRankStatisticsAgent.OperationStep.BACKOFF_SLEEP);
                BackoffHandler.this.sleepTime = this.nextSleepDuration(BackoffHandler.this.numRetries);
                long sleepStartTime = System.currentTimeMillis();
                if (sleepStartTime < BackoffHandler.this.timeoutTime && sleepStartTime + BackoffHandler.this.sleepTime > BackoffHandler.this.timeoutTime) {
                    BackoffHandler.this.sleepTime = BackoffHandler.this.timeoutTime - sleepStartTime;
                }
                try {
                    Thread.sleep(BackoffHandler.this.sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                BackoffHandler.this.lexoRankStatisticsAgent.endOperationStep(LexoRankStatisticsAgent.OperationStep.BACKOFF_SLEEP);
            }
            BackoffHandler.this.numRetries++;
        }

        public long nextSleepDuration(int retries) {
            return retries * 2 + rand.nextInt(retries * 3);
        }
    }

    class LegacySleepStrategy
    implements SleepStrategy {
        LegacySleepStrategy() {
        }

        @Override
        public void backoff() {
            if (BackoffHandler.this.numRetries != 0) {
                if (BackoffHandler.this.numRetries == 1) {
                    BackoffHandler.this.lexoRankStatisticsAgent.startOperationStep(LexoRankStatisticsAgent.OperationStep.BACKOFF_YIELD);
                    Thread.yield();
                    BackoffHandler.this.lexoRankStatisticsAgent.endOperationStep(LexoRankStatisticsAgent.OperationStep.BACKOFF_YIELD);
                } else {
                    BackoffHandler.this.lexoRankStatisticsAgent.startOperationStep(LexoRankStatisticsAgent.OperationStep.BACKOFF_SLEEP);
                    BackoffHandler.this.sleepTime = BackoffHandler.this.sleepTime + this.nextSleepDuration(BackoffHandler.this.numRetries);
                    long sleepStartTime = System.currentTimeMillis();
                    if (sleepStartTime < BackoffHandler.this.timeoutTime && sleepStartTime + BackoffHandler.this.sleepTime > BackoffHandler.this.timeoutTime) {
                        BackoffHandler.this.sleepTime = BackoffHandler.this.timeoutTime - sleepStartTime;
                    }
                    try {
                        Thread.sleep(BackoffHandler.this.sleepTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    BackoffHandler.this.lexoRankStatisticsAgent.endOperationStep(LexoRankStatisticsAgent.OperationStep.BACKOFF_SLEEP);
                }
            }
            BackoffHandler.this.numRetries++;
        }

        long nextSleepDuration(int retries) {
            return retries * 50 + rand.nextInt(retries * 50);
        }
    }

    static interface SleepStrategy {
        public void backoff();
    }
}

