/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issuelink;

import com.atlassian.beehive.compat.ClusterLock;
import com.atlassian.beehive.compat.ClusterLockService;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.issuelink.SplitIssueLinkTypeService;
import com.atlassian.greenhopper.service.properties.PropertyDao;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SplitIssueLinkTypeServiceImpl
implements SplitIssueLinkTypeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SplitIssueLinkTypeServiceImpl.class);
    @VisibleForTesting
    static final String KEY_ISSUE_LINK_TYPE_ID = "GreenHopper.SplitIssue.IssueLinkType.Id";
    @VisibleForTesting
    static final String ISSUE_LINK_TYPE_STYLE = "gh_split_issue";
    private final PropertyDao propertyDao;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final ClusterLockService clusterLockService;
    private final I18nFactoryService i18nFactoryService;

    @Autowired
    public SplitIssueLinkTypeServiceImpl(PropertyDao propertyDao, IssueLinkTypeManager issueLinkTypeManager, I18nFactoryService i18nFactoryService, ClusterLockService clusterLockService) {
        this.propertyDao = propertyDao;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.clusterLockService = clusterLockService;
        this.i18nFactoryService = i18nFactoryService;
    }

    @Override
    public IssueLinkType getOrCreateIssueLinkType() {
        Long issueLinkTypeId = this.propertyDao.getLongProperty(KEY_ISSUE_LINK_TYPE_ID);
        if (issueLinkTypeId == null) {
            LOGGER.debug("Unable to find issue link type id for split issue. Creating a new one.");
            return this.createIssueLinkType();
        }
        IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(issueLinkTypeId, false);
        if (issueLinkType == null) {
            LOGGER.warn("Managed to look up issue link type id for split issue from property store but unable to get issue link type by id: {}. Creating a new one.", (Object)issueLinkTypeId);
            return this.createIssueLinkType();
        }
        return issueLinkType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IssueLinkType createIssueLinkType() {
        IssueLinkType issueLinkType;
        I18n2 i18n = this.i18nFactoryService.getI18n();
        ClusterLock lock = this.clusterLockService.getLockForName(ISSUE_LINK_TYPE_STYLE);
        lock.lock();
        try {
            issueLinkType = this.getIssueLinkTypeByStyle();
            if (issueLinkType == null) {
                LOGGER.debug("Creating a new issue link type for split issue.");
                this.issueLinkTypeManager.createIssueLinkType(i18n.getText("gh.issue.split.issue.link.type.name"), i18n.getText("gh.issue.split.issue.link.type.outward.name"), i18n.getText("gh.issue.split.issue.link.type.inward.name"), ISSUE_LINK_TYPE_STYLE);
            } else {
                LOGGER.warn("Supposed to create a new issue link type for split issue but found issue link type with id {}. Not creating.", (Object)issueLinkType.getId());
            }
        }
        finally {
            lock.unlock();
        }
        issueLinkType = this.getIssueLinkTypeByStyle();
        if (issueLinkType == null) {
            throw new RuntimeException("Failed to create issue link type for split issue.");
        }
        this.propertyDao.setLongProperty(KEY_ISSUE_LINK_TYPE_ID, issueLinkType.getId());
        return issueLinkType;
    }

    private IssueLinkType getIssueLinkTypeByStyle() {
        Collection issueLinkTypes = this.issueLinkTypeManager.getIssueLinkTypesByStyle(ISSUE_LINK_TYPE_STYLE);
        if (issueLinkTypes.isEmpty()) {
            return null;
        }
        if (issueLinkTypes.size() == 1) {
            return (IssueLinkType)issueLinkTypes.stream().findFirst().get();
        }
        String issueLinkTypeIds = issueLinkTypes.stream().map(t -> t.getId().toString()).collect(Collectors.joining(", "));
        LOGGER.warn("Found more than one issue link type with style {}: {}. Returning the one with the smallest id.", (Object)ISSUE_LINK_TYPE_STYLE, (Object)issueLinkTypeIds);
        return issueLinkTypes.stream().min(Comparator.comparingLong(IssueLinkType::getId)).get();
    }
}

