/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issuelink;

import com.atlassian.greenhopper.issue.IssuePermissionService;
import com.atlassian.greenhopper.manager.issuelink.EpicLinkManager;
import com.atlassian.greenhopper.model.Epic;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.atlassian.greenhopper.service.Pages;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issue.IssueUpdateService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.issuelink.EpicQuery;
import com.atlassian.greenhopper.service.issuelink.EpicService;
import com.atlassian.greenhopper.service.issuelink.IssueLinkRequest;
import com.atlassian.greenhopper.service.issuelink.IssueUnlinkRequest;
import com.atlassian.greenhopper.web.rapid.list.CollectIssuesResult;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryQueryServiceImpl;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.option.LazyLoadedOption;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.CollectionBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class EpicServiceImpl
implements EpicService {
    @Autowired
    private EpicLinkManager epicLinkManager;
    @Autowired
    private IssueTypeService issueTypeService;
    @Autowired
    private RapidIssueEntryQueryServiceImpl rapidIssueEntryQueryService;
    @Autowired
    private IssueService issueService;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    @Autowired
    private IssuePermissionService issuePermissionService;
    @Autowired
    private IssueUpdateService issueUpdateService;

    @Override
    @Nonnull
    public ServiceResult addIssuesToEpic(@Nullable ApplicationUser user, Issue epic, Set<Issue> issues) {
        return this.addIssuesToEpic(IssueLinkRequest.linkEpic(user, epic, issues));
    }

    @Override
    @Nonnull
    public ServiceResult addIssuesToEpic(@Nullable ApplicationUser user, Epic epic, Set<Issue> issues) {
        return this.addIssuesToEpic(IssueLinkRequest.linkEpic(user, epic, issues));
    }

    @Override
    @Nonnull
    public ServiceResult addIssuesToEpic(@Nonnull IssueLinkRequest request) {
        if (request.getIssuesToLink().isEmpty()) {
            return ServiceResultImpl.ok();
        }
        ServiceOutcome epicOutcome = (ServiceOutcome)request.getEpic().fold(ServiceOutcomeImpl::ok, epic -> this.epicToIssue(request.getUser(), (Epic)epic));
        if (!epicOutcome.isValid()) {
            return epicOutcome;
        }
        Issue epic2 = (Issue)epicOutcome.get();
        IssueType epicIssueType = this.issueTypeService.getOrCreateEpicIssueType();
        if (!epicIssueType.equals(epic2.getIssueType())) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.epic.error.not.found", new Object[0]);
        }
        for (Issue issue : request.getIssuesToLink()) {
            if (epicIssueType.equals(issue.getIssueType())) {
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.epic.associate.error.issue.types.for.epic", issue.getKey());
            }
            if (!issue.isSubTask()) continue;
            return ServiceOutcomeImpl.error("soft-error", ErrorCollection.Reason.VALIDATION_FAILED, "gh.epic.associate.error.subtask", "<br /><br />");
        }
        ServiceResult permission = this.issuePermissionService.canEditAllIssues(request.getUser(), CollectionBuilder.newBuilder((Object[])new Issue[]{epic2}).addAll(request.getIssuesToLink()).asList());
        if (!permission.isValid()) {
            return permission;
        }
        return this.epicLinkManager.associateIssuesWithEpic(request.getUser(), (io.atlassian.fugue.Option<Issue>)io.atlassian.fugue.Option.some((Object)epic2), request.getIssuesToLink(), request.isDispatchEvent());
    }

    @Nonnull
    private ServiceOutcome<Issue> epicToIssue(@Nullable ApplicationUser user, Epic epic) {
        IssueService.IssueResult issueResult = this.issueService.getIssue(user, epic.getId());
        if (!issueResult.isValid()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.epic.error.noview", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(issueResult.getIssue());
    }

    @Override
    @Nonnull
    public ServiceResult removeEpicFromIssues(@Nullable ApplicationUser user, Set<Issue> issues) {
        return this.removeEpicFromIssues(IssueUnlinkRequest.unlinkEpic(user, issues));
    }

    @Override
    @Nonnull
    public ServiceResult removeEpicFromIssues(@Nonnull IssueUnlinkRequest request) {
        ServiceResult permission = this.issuePermissionService.canEditAllIssues(request.getUser(), new ArrayList<Issue>(request.getIssuesToUnlink()));
        if (!permission.isValid()) {
            return permission;
        }
        return this.epicLinkManager.disassociateEpicFromIssues(request.getUser(), request.getIssuesToUnlink(), request.isDispatchEvent());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Page<Epic>> getEpics(@Nullable ApplicationUser user, RapidView rapidView, PageRequest pageRequest, EpicQuery epicQuery) {
        ServiceOutcome<CollectIssuesResult> collectIssuesResult = this.rapidIssueEntryQueryService.collectEpicIssues(user, rapidView);
        if (collectIssuesResult.isInvalid()) {
            return ServiceOutcomeImpl.error(collectIssuesResult);
        }
        Stream<RapidIssueEntry> issues = this.filterIssue(collectIssuesResult.get().getIssues(), epicQuery);
        Stream<Epic> epics = issues.map(input -> Epic.builder().id(input.getIssueId()).key(input.getIssueKey()).summary(input.summary).name(input.epicLabel).colorKey(input.epicColor).done(input.hidden).build());
        return ServiceOutcomeImpl.ok(Pages.toPage(epics::iterator, pageRequest, null));
    }

    @Override
    @Nonnull
    public ServiceOutcome<Epic> getEpic(@Nullable ApplicationUser user, @Nonnull Long epicId) {
        return this.getEpicForIssue(this.issueService.getIssue(user, epicId));
    }

    @Override
    @Nonnull
    public ServiceOutcome<Epic> getEpic(@Nullable ApplicationUser user, @Nonnull String epicKey) {
        return this.getEpicForIssue(this.issueService.getIssue(user, epicKey));
    }

    @Override
    public boolean isEpic(@Nonnull Issue issue) {
        IssueType epicIssueType = this.issueTypeService.getOrCreateEpicIssueType();
        return epicIssueType.getId().equals(issue.getIssueTypeId());
    }

    @Override
    public ServiceOutcome<Epic> updateEpic(ApplicationUser user, Epic epic) {
        ServiceOutcome<Issue> epicAsIssue = this.getEpicAsIssue(user, epic);
        if (!epicAsIssue.isValid()) {
            return ServiceOutcomeImpl.error(epicAsIssue);
        }
        IssueInputParametersImpl issueInputParameters = new IssueInputParametersImpl();
        issueInputParameters.setSummary(epic.getSummary());
        issueInputParameters.addCustomFieldValue(this.epicCustomFieldService.getDefaultEpicColorField().getId(), new String[]{epic.getColorKey()});
        issueInputParameters.addCustomFieldValue(this.epicCustomFieldService.getDefaultEpicLabelField().getId(), new String[]{epic.getName()});
        io.atlassian.fugue.Option<Long> epicDoneStatusValue = this.getEpicDoneStatusValue();
        if (epic.isDone() && epicDoneStatusValue.isDefined()) {
            issueInputParameters.addCustomFieldValue(this.epicCustomFieldService.getDefaultEpicStatusField().getId(), new String[]{((Long)epicDoneStatusValue.get()).toString()});
        } else {
            issueInputParameters.addCustomFieldValue(this.epicCustomFieldService.getDefaultEpicStatusField().getId(), new String[]{null});
        }
        IssueService.UpdateValidationResult updateValidationResult = this.issueUpdateService.validateUpdate(user, epic.getId(), (IssueInputParameters)issueInputParameters);
        if (!updateValidationResult.isValid()) {
            return ServiceOutcomeImpl.fromJiraErrorCollectionWithReasons(updateValidationResult.getErrorCollection());
        }
        IssueService.IssueResult updateResult = this.issueUpdateService.update(user, updateValidationResult);
        if (!updateResult.isValid()) {
            return ServiceOutcomeImpl.fromJiraErrorCollectionWithReasons(updateResult.getErrorCollection());
        }
        return ServiceOutcomeImpl.ok(epic);
    }

    private ServiceOutcome<Epic> getEpicForIssue(IssueService.IssueResult issueResult) {
        if (!issueResult.isValid()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.epic.error.noview", new Object[0]);
        }
        MutableIssue issue = issueResult.getIssue();
        IssueType epicIssueType = this.issueTypeService.getOrCreateEpicIssueType();
        if (issue.getIssueTypeId() == null || !issue.getIssueTypeId().equals(epicIssueType.getId())) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.epic.error.noview", new Object[0]);
        }
        String color = (String)this.epicCustomFieldService.getDefaultEpicColorField().getValue((Issue)issue);
        String label = (String)this.epicCustomFieldService.getDefaultEpicLabelField().getValue((Issue)issue);
        io.atlassian.fugue.Option<Long> epicStatusValue = this.getEpicStatusValue((Issue)issue);
        boolean isDone = epicStatusValue.isDefined() && epicStatusValue.equals(this.getEpicDoneStatusValue());
        Epic epic = Epic.builder().id(issue.getId()).key(issue.getKey()).summary(issue.getSummary()).name(label).colorKey(color).done(isDone).build();
        return ServiceOutcomeImpl.ok(epic);
    }

    private ServiceOutcome<Issue> getEpicAsIssue(ApplicationUser user, Epic epic) {
        IssueService.IssueResult issueResult = this.issueService.getIssue(user, epic.getId());
        if (!issueResult.isValid()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.epic.error.noview", new Object[0]);
        }
        MutableIssue issue = issueResult.getIssue();
        if (!issue.getKey().equals(epic.getKey())) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.epic.error.noview", new Object[0]);
        }
        if (!this.isEpic((Issue)issue)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.epic.error.noview", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(issue);
    }

    private Stream<RapidIssueEntry> filterIssue(List<RapidIssueEntry> issues, EpicQuery query) {
        Boolean done = query.isDone();
        if (done == null) {
            return issues.stream();
        }
        return issues.stream().filter(input -> input.hidden == done);
    }

    private io.atlassian.fugue.Option<Long> getEpicDoneStatusValue() {
        io.atlassian.fugue.Option<Option> doneEpicStatusOption = this.epicCustomFieldService.getDoneEpicStatusOption();
        return doneEpicStatusOption.flatMap(input -> {
            if (input == null || input.getOptionId() == null) {
                return io.atlassian.fugue.Option.none();
            }
            return io.atlassian.fugue.Option.some((Object)input.getOptionId());
        });
    }

    private io.atlassian.fugue.Option<Long> getEpicStatusValue(Issue issue) {
        LazyLoadedOption value = (LazyLoadedOption)this.epicCustomFieldService.getDefaultEpicStatusField().getValue(issue);
        if (value == null) {
            return io.atlassian.fugue.Option.none();
        }
        Long statusValue = value.getOptionId();
        if (statusValue == null) {
            return io.atlassian.fugue.Option.none();
        }
        return io.atlassian.fugue.Option.some((Object)statusValue);
    }
}

