/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issuelink;

import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issue.callback.EpicLabelAndKeyMatchingCallback;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.issuelink.EpicNamesResult;
import com.atlassian.greenhopper.service.issuelink.EpicPickerService;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EpicPickerServiceImpl
implements EpicPickerService {
    @Autowired
    private IssueTypeService issueTypeService;
    @Autowired
    private IssueDataService issueDataService;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    @Autowired
    private I18nFactoryService i18nFactoryService;

    @Override
    @Nonnull
    public ServiceOutcome<List<EpicNamesResult>> listEpicNames(@Nullable ApplicationUser user, String searchTerm, int maxResults, @Nullable String prioritizedProjects, boolean hideDone, boolean filterEpicByGivenProjects) {
        CustomField epicLabelField = this.epicCustomFieldService.getDefaultEpicLabelField();
        Query query = JqlQueryBuilder.newBuilder().where().issueType(new String[]{this.issueTypeService.getOrCreateEpicIssueType().getName()}).endWhere().orderBy().issueKey(SortOrder.ASC).buildQuery();
        CustomField epicStatusField = this.epicCustomFieldService.getDefaultEpicStatusField();
        io.atlassian.fugue.Option<Option> doneEpicStatusOption = this.epicCustomFieldService.getDoneEpicStatusOption();
        String epicDoneStatusValue = doneEpicStatusOption.isDefined() ? ((Option)doneEpicStatusOption.get()).getOptionId().toString() : "";
        EpicLabelAndKeyMatchingCallback callback = EpicLabelAndKeyMatchingCallback.Builder.newBuilder().epicLabelCustomFieldId(epicLabelField.getId()).epicStatusCustomField(epicStatusField.getId()).epicDoneStatusValue(epicDoneStatusValue).searchTerm(searchTerm).maxResults(maxResults).projectKeys(EpicPickerServiceImpl.projectKeysAsList(prioritizedProjects)).hideDone(hideDone).filterEpicByGivenProjects(filterEpicByGivenProjects).i18n2(this.i18nFactoryService.getI18n()).build();
        this.issueDataService.find(user, query, callback);
        List<EpicNamesResult> matchingEpicNames = callback.getIssues();
        return ServiceOutcomeImpl.ok(matchingEpicNames);
    }

    private static List<String> projectKeysAsList(String prioritizedProjectKeys) {
        if (StringUtils.contains((CharSequence)prioritizedProjectKeys, (CharSequence)",")) {
            return Arrays.asList(prioritizedProjectKeys.replaceAll("\\s+", "").split(","));
        }
        if (StringUtils.isNotBlank((CharSequence)prioritizedProjectKeys)) {
            return Arrays.asList(prioritizedProjectKeys);
        }
        return Collections.emptyList();
    }
}

