/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issuelink;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.service.issuelink.EpicLinkTypeService;
import com.atlassian.greenhopper.service.properties.PropertyDao;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import java.util.Collection;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EpicLinkTypeServiceImpl
implements EpicLinkTypeService {
    private static final String KEY_DEFAULT_EPIC_LINKTYPE_ID = "GreenHopper.Epic.Default.linktype.id";
    private LoggerWrapper logger = LoggerWrapper.with(this.getClass());
    @Autowired
    private PropertyDao propertyDao;
    @Autowired
    private IssueLinkTypeManager issueLinkTypeManager;

    @Override
    public IssueLinkType getOrCreateEpicLinkType() {
        return this.getEpicLinkType().orElseGet(this::createEpicLinkType);
    }

    private Optional<IssueLinkType> getEpicLinkType() {
        Long epicLinkTypeId = this.propertyDao.getLongProperty(KEY_DEFAULT_EPIC_LINKTYPE_ID);
        if (epicLinkTypeId != null) {
            return Optional.ofNullable(this.issueLinkTypeManager.getIssueLinkType(epicLinkTypeId, false));
        }
        return Optional.empty();
    }

    private synchronized IssueLinkType createEpicLinkType() {
        return this.getEpicLinkType().orElseGet(() -> {
            this.issueLinkTypeManager.createIssueLinkType("Epic-Story Link", "is Epic of", "has Epic", "jira_gh_epic_story");
            Collection linkTypes = this.issueLinkTypeManager.getIssueLinkTypesByStyle("jira_gh_epic_story");
            if (linkTypes.size() > 1) {
                this.logger.warn("More than one issue link type with GreenHopper link style -- using first", new Object[0]);
            } else if (linkTypes.isEmpty()) {
                this.logger.error("Could not create issue link type for Epic-Story relationship", new Object[0]);
                throw new RuntimeException("Could not create issue link type for Epic-Story relationship");
            }
            IssueLinkType epicLinkType = (IssueLinkType)linkTypes.iterator().next();
            this.propertyDao.setLongProperty(KEY_DEFAULT_EPIC_LINKTYPE_ID, epicLinkType.getId());
            this.logger.info("Epic-Story Link Type now exists with ID %d", epicLinkType.getId());
            return epicLinkType;
        });
    }
}

