/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issuelink;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.customfield.CustomFieldMetadata;
import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.customfield.CustomFieldUtil;
import com.atlassian.greenhopper.customfield.epiccolor.EpicColorCFType;
import com.atlassian.greenhopper.customfield.epiclabel.EpicLabelCFType;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkCFType;
import com.atlassian.greenhopper.customfield.epicstatus.EpicStatusCFType;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.issue.fields.ManagedCustomFieldProvider;
import com.atlassian.greenhopper.manager.issue.issuetypes.EpicIssueTypeChangedEvent;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.properties.PropertyDao;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EpicCustomFieldServiceImpl
implements EpicCustomFieldService,
ManagedCustomFieldProvider {
    private static final String KEY_DEFAULT_EPIC_LABEL_CUSTOMFIELD_ID = "GreenHopper.EpicLabel.Default.customfield.id";
    private static final String KEY_DEFAULT_EPIC_LINK_CUSTOMFIELD_ID = "GreenHopper.EpicLink.Default.customfield.id";
    private static final String KEY_DEFAULT_EPIC_STATUS_CUSTOMFIELD_ID = "GreenHopper.EpicStatus.Default.customfield.id";
    private static final String KEY_DEFAULT_EPIC_COLOR_CUSTOMFIELD_ID = "GreenHopper.EpicColor.Default.customfield.id";
    private final LoggerWrapper logger = LoggerWrapper.with(this.getClass());
    @Autowired
    private PropertyDao propertyDao;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    private ReindexMessageManager reindexMessageManager;
    @Autowired
    private IssueTypeService issueTypeService;
    @Autowired
    private EventPublisher eventPublisher;
    private final Map<EpicFieldType, FieldFactory> epicFieldTypeFactories = new HashMap<EpicFieldType, FieldFactory>(EpicFieldType.values().length);

    @PostConstruct
    public void onSpringContextStarted() {
        this.eventPublisher.register((Object)this);
        this.epicFieldTypeFactories.put(EpicFieldType.EPIC_LABEL, new EpicLabelFieldFactory());
        this.epicFieldTypeFactories.put(EpicFieldType.EPIC_LINK, new BaseFieldFactory());
        this.epicFieldTypeFactories.put(EpicFieldType.EPIC_COLOR, new BaseFieldFactory());
        this.epicFieldTypeFactories.put(EpicFieldType.EPIC_STATUS, new BaseFieldFactory());
    }

    @PreDestroy
    public void onSpringContextStopped() {
        this.eventPublisher.unregister((Object)this);
    }

    @Override
    public CustomField getDefaultEpicLabelField() {
        return this.getDefaultField(EpicFieldType.EPIC_LABEL);
    }

    @Override
    public CustomField getDefaultEpicLinkField() {
        return this.getDefaultField(EpicFieldType.EPIC_LINK);
    }

    @Override
    public CustomField getDefaultEpicStatusField() {
        return this.getDefaultField(EpicFieldType.EPIC_STATUS);
    }

    @Override
    public CustomField getDefaultEpicColorField() {
        return this.getDefaultField(EpicFieldType.EPIC_COLOR);
    }

    @Override
    public void ensureEpicFieldsHaveCorrectContext() {
        for (EpicFieldType epicFieldType : EpicFieldType.values()) {
            if (!epicFieldType.usesEpicIssueTypeContext) continue;
            CustomFieldMetadata customFieldMetadata = this.epicFieldTypeFactories.get((Object)epicFieldType).defineMetadata(epicFieldType);
            CustomField field = this.getDefaultField(epicFieldType);
            this.customFieldService.associateCustomFieldContext(field, customFieldMetadata);
        }
    }

    @Override
    public void ensureEpicStatusFieldHasCorrectOptionsOrder() {
        this.customFieldService.setOptionsOrderFromMetadata(this.getDefaultEpicStatusField(), this.epicFieldTypeFactories.get((Object)EpicFieldType.EPIC_STATUS).defineMetadata(EpicFieldType.EPIC_STATUS));
    }

    @Override
    public io.atlassian.fugue.Option<Option> getDoneEpicStatusOption() {
        IssueType epicIssueType = this.issueTypeService.getOrCreateEpicIssueType();
        CustomField defaultEpicStatusField = this.getDefaultEpicStatusField();
        io.atlassian.fugue.Option<FieldConfig> fieldConfig = CustomFieldUtil.getRelevantConfig(defaultEpicStatusField, (IssueContext)new IssueContextImpl(null, epicIssueType.getId()));
        if (fieldConfig.isEmpty()) {
            this.logger.warn("Could not find a Custom Field Configuration for field '%s', all projects and issue type '%s' -- therefore cannot find the Option for 'Done' epics.", defaultEpicStatusField.getId(), epicIssueType.getId());
            return io.atlassian.fugue.Option.none();
        }
        io.atlassian.fugue.Option<Options> optionsResult = CustomFieldUtil.getCustomFieldOptions(defaultEpicStatusField, fieldConfig);
        if (optionsResult.isEmpty()) {
            return io.atlassian.fugue.Option.none();
        }
        Options options = (Options)optionsResult.get();
        if (options.size() < 2) {
            this.logger.info("Tried to retrieve 'Done' option for Epic Status custom field %s but there were %d Options; returning none", defaultEpicStatusField.getId(), options.size());
            return io.atlassian.fugue.Option.none();
        }
        return io.atlassian.fugue.Option.some((Object)options.get(options.size() - 1));
    }

    @Override
    @EventListener
    public void onEpicIssueTypeChanged(EpicIssueTypeChangedEvent event) {
        this.ensureEpicFieldsHaveCorrectContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CustomField getDefaultField(EpicFieldType epicFieldType) {
        CustomField field = this.getDefaultFieldOrNull(epicFieldType);
        if (field == null) {
            EpicCustomFieldServiceImpl epicCustomFieldServiceImpl = this;
            synchronized (epicCustomFieldServiceImpl) {
                field = this.getDefaultFieldOrNull(epicFieldType);
                if (field == null) {
                    field = this.createDefaultField(epicFieldType);
                }
            }
        }
        return field;
    }

    private CustomField getDefaultFieldOrNull(EpicFieldType epicFieldType) {
        this.logger.debug("Requesting the Default %s field", epicFieldType.name);
        Long id = this.propertyDao.getLongProperty(epicFieldType.propertyKey);
        if (id != null) {
            this.logger.debug("Field ID '%d' has been set -- verifying that the field still exists", id);
            CustomField field = this.customFieldService.getCustomField(id);
            if (field != null) {
                this.logger.debug("Default %s field with custom field ID '%d' exists", epicFieldType.name, field.getIdAsLong());
                return field;
            }
            if (this.customFieldService.verifyCustomFieldExistsInDB(id)) {
                throw new RuntimeException(String.format("Custom field '%s' with ID '%d' exists in DB, but was not returned by the custom field service.", epicFieldType.name, id));
            }
            this.logger.debug("Default %s field with ID '%d' did not exist", epicFieldType.name, id);
        }
        return null;
    }

    private CustomField createDefaultField(EpicFieldType epicFieldType) {
        FieldFactory fieldFactory = this.epicFieldTypeFactories.get((Object)epicFieldType);
        if (fieldFactory == null) {
            throw new IllegalArgumentException("Unknown epic field type " + (Object)((Object)epicFieldType));
        }
        return fieldFactory.create(epicFieldType);
    }

    @Override
    public Collection<CustomField> getManagedFields() {
        return Arrays.asList(this.getDefaultEpicLinkField(), this.getDefaultEpicStatusField(), this.getDefaultEpicLabelField(), this.getDefaultEpicColorField());
    }

    private static enum EpicFieldType {
        EPIC_LINK("Epic Link", "GreenHopper.EpicLink.Default.customfield.id", EpicLinkCFType.CUSTOMFIELD_METADATA, false),
        EPIC_LABEL("Epic Name", "GreenHopper.EpicLabel.Default.customfield.id", EpicLabelCFType.CUSTOMFIELD_METADATA, true),
        EPIC_STATUS("Epic Status", "GreenHopper.EpicStatus.Default.customfield.id", EpicStatusCFType.CUSTOMFIELD_METADATA, true),
        EPIC_COLOR("Epic Color", "GreenHopper.EpicColor.Default.customfield.id", EpicColorCFType.CUSTOMFIELD_METADATA, true);

        private final String name;
        private final String propertyKey;
        private final CustomFieldMetadata customFieldMetadata;
        private final boolean usesEpicIssueTypeContext;

        private EpicFieldType(String name, String propertyKey, CustomFieldMetadata customFieldMetadata, boolean usesEpicIssueTypeContext) {
            this.name = name;
            this.propertyKey = propertyKey;
            this.customFieldMetadata = customFieldMetadata;
            this.usesEpicIssueTypeContext = usesEpicIssueTypeContext;
        }
    }

    private class EpicLabelFieldFactory
    extends BaseFieldFactory
    implements FieldFactory {
        private EpicLabelFieldFactory() {
        }

        @Override
        void postCreate(CustomField field, EpicFieldType epicFieldType) {
            EpicCustomFieldServiceImpl.this.customFieldService.makeFieldRequired(field);
            super.postCreate(field, epicFieldType);
        }
    }

    private class BaseFieldFactory
    implements FieldFactory {
        private BaseFieldFactory() {
        }

        @Override
        @Nonnull
        public CustomFieldMetadata defineMetadata(EpicFieldType epicFieldType) {
            return epicFieldType.customFieldMetadata;
        }

        @Override
        @Nonnull
        public CustomField create(EpicFieldType epicFieldType) {
            CustomFieldMetadata customFieldMetadata = this.defineMetadata(epicFieldType);
            CustomField field = EpicCustomFieldServiceImpl.this.customFieldService.createCustomField(customFieldMetadata);
            this.postCreate(field, epicFieldType);
            return field;
        }

        void postCreate(CustomField field, EpicFieldType epicFieldType) {
            EpicCustomFieldServiceImpl.this.logger.info("Created Default %s field with ID '%d'", epicFieldType.name, field.getIdAsLong());
            EpicCustomFieldServiceImpl.this.propertyDao.setLongProperty(epicFieldType.propertyKey, field.getIdAsLong());
            EpicCustomFieldServiceImpl.this.reindexMessageManager.pushMessage(EpicCustomFieldServiceImpl.this.jiraAuthenticationContext.getUser(), String.format("GreenHopper %s Field Creation", epicFieldType.name));
        }
    }

    private static interface FieldFactory {
        @Nonnull
        public CustomFieldMetadata defineMetadata(EpicFieldType var1);

        @Nonnull
        public CustomField create(EpicFieldType var1);
    }
}

