/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.flagging;

import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.customfield.CustomFieldUtil;
import com.atlassian.greenhopper.manager.issue.fields.FlagCustomFieldProvider;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueUpdateService;
import com.atlassian.greenhopper.service.issue.flagging.FlagService;
import com.atlassian.greenhopper.service.issue.flagging.IssueToKeyTransformer;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlagServiceImpl
implements FlagService {
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private FlagCustomFieldProvider flagCustomFieldProvider;
    @Autowired
    private IssueUpdateService issueUpdateService;
    @Autowired
    private CustomFieldService customFieldService;

    @Override
    public ServiceOutcome<FlagService.Result> flag(ApplicationUser user, Collection<Issue> issues, boolean flag) {
        if (issues.isEmpty()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.view.error.flag.noissueprovided", new Object[0]);
        }
        CustomField field = this.getField();
        Option firstAvailableOption = this.getFlagFirstAvailableOption();
        if (firstAvailableOption == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.view.error.flag.field.no.options", this.getField().getName(), flag ? 0 : 1);
        }
        ErrorCollection errors = new ErrorCollection();
        ArrayList<Issue> flaggableIssues = new ArrayList<Issue>();
        ArrayList<Issue> issuesWithPermissionError = new ArrayList<Issue>();
        ArrayList<Issue> issuesWithWorkflowError = new ArrayList<Issue>();
        ArrayList<Issue> issuesWithFieldNotApplicableError = new ArrayList<Issue>();
        for (Issue issue : issues) {
            boolean valid = true;
            if (!this.permissionService.hasPermission(user, issue, 12)) {
                valid = false;
                issuesWithPermissionError.add(issue);
            } else if (!issue.isEditable()) {
                valid = false;
                issuesWithWorkflowError.add(issue);
            }
            if (!this.customFieldService.isFieldApplicable(field, issue)) {
                valid = false;
                issuesWithFieldNotApplicableError.add(issue);
            }
            if (!valid) continue;
            flaggableIssues.add(issue);
        }
        if (!issuesWithPermissionError.isEmpty()) {
            errors.addError(ErrorCollection.Reason.FORBIDDEN, "gh.rapid.view.error.flag.no.edit.permission", this.buildIssuesKeysString(issuesWithPermissionError), issuesWithPermissionError.size(), flag ? 0 : 1);
        }
        if (!issuesWithWorkflowError.isEmpty()) {
            errors.addError(ErrorCollection.Reason.FORBIDDEN, "gh.rapid.view.error.flag.no.edit.workflow", this.buildIssuesKeysString(issuesWithWorkflowError), issuesWithWorkflowError.size(), flag ? 0 : 1);
        }
        if (!issuesWithFieldNotApplicableError.isEmpty()) {
            errors.addError(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.view.error.flag.field.notapplicable", this.buildIssuesKeysString(issuesWithFieldNotApplicableError), issuesWithFieldNotApplicableError.size(), field.getName(), flag ? 0 : 1);
        }
        if (flaggableIssues.isEmpty()) {
            return ServiceOutcomeImpl.from(errors);
        }
        ArrayList<Issue> flaggedIssues = new ArrayList<Issue>();
        for (Issue flaggableIssue : flaggableIssues) {
            ServiceOutcome<Void> executionOutcome = flag ? this.doFlag(user, flaggableIssue) : this.doUnFlag(user, flaggableIssue);
            if (executionOutcome.isValid()) {
                flaggedIssues.add(flaggableIssue);
                continue;
            }
            errors.addAllErrors(executionOutcome.getErrors());
        }
        if (flaggedIssues.isEmpty()) {
            return ServiceOutcomeImpl.from(errors);
        }
        return ServiceOutcomeImpl.ok(new FlagService.Result(flaggedIssues, errors));
    }

    @Override
    public Boolean isFlagged(Issue issue) {
        if (!this.flagCustomFieldProvider.doesDefaultFieldExist()) {
            return false;
        }
        Object rawValue = this.getField().getValue(issue);
        if (rawValue == null) {
            return false;
        }
        if (rawValue instanceof Collection) {
            Collection values = (Collection)rawValue;
            return !values.isEmpty();
        }
        return false;
    }

    private ServiceOutcome<Void> doFlag(ApplicationUser user, Issue issue) {
        Option flagValue = this.getFlagFirstAvailableOption();
        return this.updateFlagField(user, issue, (Collection<String>)ImmutableList.of((Object)flagValue.getOptionId().toString()));
    }

    private ServiceOutcome<Void> doUnFlag(ApplicationUser user, Issue issue) {
        return this.updateFlagField(user, issue, Collections.emptyList());
    }

    private CustomField getField() {
        return this.flagCustomFieldProvider.getOrCreateDefaultField();
    }

    private Option getFlagFirstAvailableOption() {
        io.atlassian.fugue.Option<Options> optionsResult = this.getFlagAvailableOptions();
        if (!optionsResult.isEmpty()) {
            Options options = (Options)optionsResult.get();
            for (Option option : options.getRootOptions()) {
                if (option.getDisabled().booleanValue()) continue;
                return option;
            }
        }
        return null;
    }

    private io.atlassian.fugue.Option<Options> getFlagAvailableOptions() {
        CustomField customField = this.getField();
        io.atlassian.fugue.Option<FieldConfig> config = CustomFieldUtil.getOneAndOnlyConfig(customField);
        return CustomFieldUtil.getCustomFieldOptions(customField, config);
    }

    private ServiceOutcome<Void> updateFlagField(ApplicationUser user, Issue issue, Collection<String> fieldValueIds) {
        CustomField customField = this.getField();
        IssueInputParametersImpl issueInputParameters = new IssueInputParametersImpl();
        issueInputParameters.addCustomFieldValue(customField.getIdAsLong(), fieldValueIds.toArray(new String[0]));
        IssueService.UpdateValidationResult updateValidationResult = this.issueUpdateService.validateUpdate(user, issue.getId(), (IssueInputParameters)issueInputParameters);
        if (!updateValidationResult.isValid()) {
            return ServiceOutcomeImpl.from(updateValidationResult.getErrorCollection());
        }
        IssueService.IssueResult updateResult = this.issueUpdateService.update(user, updateValidationResult);
        if (!updateResult.isValid()) {
            return ServiceOutcomeImpl.from(updateResult.getErrorCollection());
        }
        return ServiceOutcomeImpl.ok();
    }

    private String buildIssuesKeysString(Collection<Issue> issues) {
        return Joiner.on((String)", ").join(Iterables.transform(issues, (Function)IssueToKeyTransformer.INSTANCE));
    }
}

