/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.field;

import com.atlassian.greenhopper.issue.fields.status.IssueStatus;
import com.atlassian.greenhopper.issue.fields.status.IssueStatusCategory;
import com.atlassian.greenhopper.service.issue.field.IssueStatusService;
import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.status.SimpleStatus;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssueStatusServiceImpl
implements IssueStatusService {
    @Autowired
    private StatusManager statusManager;
    @Autowired
    private StatusCategoryManager statusCategoryManager;

    @Override
    public IssueStatus getIssueStatus(Status status) {
        return this.getSimpleIssueStatus(status.getSimpleStatus());
    }

    @Override
    public IssueStatus getIssueStatus(Object simpleStatusObject) {
        if (!(simpleStatusObject instanceof SimpleStatus)) {
            throw new RuntimeException("Expected instance of SimpleStatue, got " + simpleStatusObject.getClass());
        }
        return this.getSimpleIssueStatus((SimpleStatus)simpleStatusObject);
    }

    private IssueStatus getSimpleIssueStatus(SimpleStatus simpleStatus) {
        if (simpleStatus == null) {
            return null;
        }
        return new IssueStatus(simpleStatus.getId(), simpleStatus.getName(), simpleStatus.getDescription(), simpleStatus.getIconUrl(), this.convertStatusCategory(simpleStatus.getStatusCategory()));
    }

    private IssueStatusCategory convertStatusCategory(StatusCategory statusCategory) {
        if (statusCategory == null) {
            return null;
        }
        return new IssueStatusCategory(statusCategory.getId(), statusCategory.getKey(), statusCategory.getColorName());
    }

    @Override
    public Status createStatus(String name, String descr, Long statusCategoryId) {
        StatusCategory statusCategory = null;
        if (statusCategoryId != null) {
            statusCategory = this.statusCategoryManager.getStatusCategory(statusCategoryId);
        }
        if (statusCategory == null) {
            return this.statusManager.createStatus(name, descr, "/");
        }
        return this.statusManager.createStatus(name, descr, "/", statusCategory);
    }
}

