/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.comment;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.comment.BulkCommentService;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.AttachmentValidator;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BulkCommentServiceImpl
implements BulkCommentService {
    private final CommentService commentService;
    private final FieldManager fieldManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final AttachmentManager attachmentManager;
    private final AttachmentValidator attachmentValidator;

    @Autowired
    public BulkCommentServiceImpl(CommentService commentService, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, AttachmentManager attachmentManager, AttachmentValidator attachmentValidator) {
        this.commentService = commentService;
        this.fieldManager = fieldManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.attachmentManager = attachmentManager;
        this.attachmentValidator = attachmentValidator;
    }

    @Override
    public ServiceOutcome<BulkCommentService.Result> addComment(ApplicationUser user, Collection<Issue> issues, String commentBody, CommentVisibility commentVisibility) {
        return this.addComment(user, issues, commentBody, commentVisibility, Collections.emptyList());
    }

    @Override
    public ServiceOutcome<BulkCommentService.Result> addComment(ApplicationUser user, Collection<Issue> issues, String commentBody, CommentVisibility commentVisibility, Collection<String> temporaryAttachments) {
        List<Issue> issuesWithAttachmentError;
        Preconditions.checkArgument((!issues.isEmpty() ? 1 : 0) != 0, (Object)"Collection of issues to comment on cannot be empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentBody) ? 1 : 0) != 0, (Object)"Comment should be non-null and non-empty");
        ArrayList updatedIssues = Lists.newArrayList();
        ArrayList issuesWithPermissionError = Lists.newArrayList();
        ErrorCollection errorCollection = new ErrorCollection();
        String commentGroupLevel = commentVisibility.getGroupLevel();
        Long commentRoleLevelId = this.getRoleLevelId(commentVisibility);
        for (Issue issue : issues) {
            CommentService.CommentParameters commentParameters = CommentService.CommentParameters.builder().author(user).body(commentBody).groupLevel(commentGroupLevel).issue(issue).roleLevelId(commentRoleLevelId).build();
            CommentService.CommentCreateValidationResult validationResult = this.commentService.validateCommentCreate(user, commentParameters);
            if (validationResult.isValid()) {
                this.commentService.create(user, validationResult, true);
                updatedIssues.add(issue);
                continue;
            }
            ErrorCollection validationErrors = ErrorCollection.fromJiraErrorCollectionWithReasons(validationResult.getErrorCollection());
            if (validationErrors.getDefinitiveReason() == ErrorCollection.Reason.FORBIDDEN) {
                issuesWithPermissionError.add(issue);
                continue;
            }
            errorCollection.addAllErrors(validationErrors);
            break;
        }
        if (!issuesWithPermissionError.isEmpty()) {
            String issueKeysStr = issuesWithPermissionError.stream().map(Issue::getKey).collect(Collectors.joining(", "));
            errorCollection.addError(ErrorCollection.Reason.FORBIDDEN, "gh.rapid.view.error.flag.and.comment.no.comment.permission", issueKeysStr);
        }
        if (!(issuesWithAttachmentError = this.handleAttachments(user, temporaryAttachments, issues)).isEmpty()) {
            String issueKeysStr = issuesWithAttachmentError.stream().map(Issue::getKey).collect(Collectors.joining(", "));
            errorCollection.addError("gh.rapid.view.error.flag.and.comment.no.attachment.permission", issueKeysStr);
        }
        return ServiceOutcomeImpl.ok(new BulkCommentService.Result(updatedIssues, errorCollection));
    }

    private List<Issue> handleAttachments(ApplicationUser user, Collection<String> temporaryAttachments, Collection<Issue> issues) {
        ArrayList issuesWithAttachmentError = Lists.newArrayList();
        if (!temporaryAttachments.isEmpty()) {
            Collection<Long> attachmentsToCopy = Collections.emptyList();
            OrderableField attachmentField = (OrderableField)this.fieldManager.getField("attachment");
            for (Issue issue : issues) {
                if (issue instanceof MutableIssue && this.attachmentValidator.canCreateAttachments(user, issue, (com.atlassian.jira.util.ErrorCollection)new SimpleErrorCollection())) {
                    MutableIssue mutableIssue = (MutableIssue)issue;
                    if (!attachmentsToCopy.isEmpty()) {
                        this.copyAttachments(user, attachmentsToCopy, mutableIssue);
                        continue;
                    }
                    attachmentsToCopy = this.convertTemporaryAttachmentsToAttachments(temporaryAttachments, attachmentsToCopy, attachmentField, mutableIssue);
                    continue;
                }
                issuesWithAttachmentError.add(issue);
            }
        }
        return issuesWithAttachmentError;
    }

    private Collection<Long> convertTemporaryAttachmentsToAttachments(Collection<String> temporaryAttachments, Collection<Long> attachmentsToCopy, OrderableField attachmentField, MutableIssue mutableIssue) {
        FieldLayoutItem attachmentFieldLayoutItem = this.fieldLayoutManager.getFieldLayout((Issue)mutableIssue).getFieldLayoutItem(attachmentField);
        ImmutableMap fieldValuesHolder = ImmutableMap.of((Object)attachmentField.getId(), new ArrayList<String>(temporaryAttachments));
        attachmentField.updateIssue(attachmentFieldLayoutItem, mutableIssue, (Map)fieldValuesHolder);
        DefaultIssueChangeHolder changeHolder = new DefaultIssueChangeHolder();
        ModifiedValue modifiedValue = (ModifiedValue)mutableIssue.getModifiedFields().get("attachment");
        if (Objects.nonNull(modifiedValue)) {
            attachmentField.updateValue(attachmentFieldLayoutItem, (Issue)mutableIssue, modifiedValue, (IssueChangeHolder)changeHolder);
            attachmentsToCopy = changeHolder.getChangeItems().stream().map(ChangeItemBean::getTo).map(Long::parseLong).collect(Collectors.toList());
        }
        return attachmentsToCopy;
    }

    private void copyAttachments(ApplicationUser user, Collection<Long> attachmentsToCopy, MutableIssue mutableIssue) {
        for (Long attachmentId : attachmentsToCopy) {
            Attachment attachment = this.attachmentManager.getAttachment(attachmentId);
            this.attachmentManager.copyAttachment(attachment, user, mutableIssue.getKey());
        }
    }

    private Long getRoleLevelId(CommentVisibility commentVisibility) {
        String roleLevelIdStr = commentVisibility.getRoleLevel();
        return roleLevelIdStr == null ? null : Long.valueOf(Long.parseLong(roleLevelIdStr));
    }
}

