/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.changehistory;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;

public class SafeChangeHistory {
    static final SafeChangeHistoryTransformer TRANSFORMER = new SafeChangeHistoryTransformer();
    private final ChangeHistory delegate;

    public SafeChangeHistory(ChangeHistory delegate) {
        this.delegate = delegate;
    }

    public List<ChangeItemBean> getChangeItems() {
        List ciList = this.delegate.getChangeItemBeans();
        if (ciList == null) {
            return Collections.emptyList();
        }
        return ciList;
    }

    public ChangeHistory getChangeHistory() {
        return this.delegate;
    }

    public Long getId() {
        return this.delegate.getId();
    }

    public String getAuthorDisplayName() {
        return this.delegate.getAuthorDisplayName();
    }

    public Issue getIssue() {
        return this.delegate.getIssue();
    }

    public String getLevel() {
        return this.delegate.getLevel();
    }

    public Long getIssueId() {
        return this.delegate.getIssueId();
    }

    public String getUsername() {
        return this.delegate.getUsername();
    }

    public String getAuthor() {
        return this.delegate.getAuthor();
    }

    public String getFullName() {
        return this.delegate.getFullName();
    }

    public ApplicationUser getAuthorUser() {
        return this.delegate.getAuthorObject();
    }

    public Timestamp getTimePerformed() {
        return this.delegate.getTimePerformed();
    }

    public String getComment() {
        return this.delegate.getComment();
    }

    static class SafeChangeHistoryTransformer
    implements Function<ChangeHistory, SafeChangeHistory> {
        private SafeChangeHistoryTransformer() {
        }

        public SafeChangeHistory apply(ChangeHistory input) {
            return new SafeChangeHistory(input);
        }
    }
}

