/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.callback;

import com.atlassian.greenhopper.model.rapid.ColumnProgress;
import com.atlassian.greenhopper.service.issue.callback.AbstractIssueDataCallback;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class StatusProgressCallback
extends AbstractIssueDataCallback {
    private final Map<Long, ColumnProgress> issuesToColumnProgress;
    private final ColumnService.ColumnProgressMap columnProgressMap;

    public StatusProgressCallback(ColumnService.ColumnProgressMap columnProgressMap) {
        this.columnProgressMap = columnProgressMap;
        this.issuesToColumnProgress = new LinkedHashMap<Long, ColumnProgress>();
    }

    @Override
    public Set<String> getFields() {
        return Collections.singleton("status");
    }

    @Override
    public void fieldData(Long issueId, String issueKey, String fieldName, final String statusId) {
        Predicate<Status> statusPredicate = new Predicate<Status>(){

            public boolean evaluate(Status input) {
                return input.getId().equals(statusId);
            }
        };
        Map<ColumnProgress, Set<Status>> progressToStatuses = this.columnProgressMap.getProgressToStatuses();
        for (Map.Entry<ColumnProgress, Set<Status>> progressEntry : progressToStatuses.entrySet()) {
            Set<Status> statuses = progressEntry.getValue();
            if (!CollectionUtil.contains(statuses, (Predicate)statusPredicate)) continue;
            this.issuesToColumnProgress.put(issueId, progressEntry.getKey());
        }
    }

    public Map<Long, ColumnProgress> getIssuesToColumnProgress() {
        return this.issuesToColumnProgress;
    }
}

