/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.callback;

import com.atlassian.greenhopper.customfield.sprint.SprintCustomFieldIndexer;
import com.atlassian.greenhopper.service.issue.callback.AbstractIssueDataCallback;
import com.atlassian.greenhopper.util.NumberUtils;
import com.atlassian.jira.issue.fields.CustomField;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SprintIdCallback
extends AbstractIssueDataCallback {
    private final String documentId;
    private final Set<String> sprintIds;

    public SprintIdCallback(CustomField sprintCustomField, boolean includeHistoricSprints) {
        this.documentId = includeHistoricSprints ? SprintCustomFieldIndexer.getHistoryFieldId(sprintCustomField) : sprintCustomField.getId();
        this.sprintIds = new HashSet<String>();
    }

    @Override
    public Set<String> getFields() {
        return Collections.singleton(this.documentId);
    }

    @Override
    public void fieldData(Long issueId, String issueKey, String fieldName, String data) {
        if (data == null) {
            return;
        }
        this.sprintIds.add(data);
    }

    public Set<Long> getSprintIds() {
        HashSet<Long> ids = new HashSet<Long>();
        for (String sprintIdString : this.sprintIds) {
            Long sprintId = NumberUtils.toLong(sprintIdString);
            if (sprintId == null) continue;
            ids.add(sprintId);
        }
        return ids;
    }
}

