/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.callback;

import com.atlassian.greenhopper.service.issue.callback.AbstractIssueDataCallback;
import com.atlassian.jira.issue.fields.CustomField;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;

public class SprintAndProjectsCallback
extends AbstractIssueDataCallback {
    private String projectIdString;
    private Set<String> sprintIdStrings;
    private final Map<String, Set<String>> sprintToProjects;
    private final String sprintFieldDocumentId;

    public SprintAndProjectsCallback(CustomField sprintCustomField) {
        this.sprintFieldDocumentId = sprintCustomField.getId();
        this.sprintToProjects = new HashMap<String, Set<String>>();
        this.sprintIdStrings = new HashSet<String>();
    }

    @Override
    public Set<String> getFields() {
        HashSet<String> fields = new HashSet<String>();
        fields.add(this.sprintFieldDocumentId);
        fields.add("projid");
        return fields;
    }

    @Override
    public void fieldData(Long issueId, String issueKey, String fieldName, String data) {
        if (data == null) {
            return;
        }
        if (fieldName.equals("projid")) {
            this.projectIdString = data;
        } else {
            this.sprintIdStrings.add(data);
        }
    }

    @Override
    public void issueComplete(Long issueId, String issueKey, Option<Document> issueDoc) {
        if (this.projectIdString == null) {
            return;
        }
        for (String sprintIdString : this.sprintIdStrings) {
            Set<String> projects = this.sprintToProjects.get(sprintIdString);
            if (projects == null) {
                projects = new HashSet<String>();
                this.sprintToProjects.put(sprintIdString, projects);
            }
            projects.add(this.projectIdString);
        }
        this.projectIdString = null;
        this.sprintIdStrings.clear();
    }

    public Map<String, Set<String>> getSprintToProjects() {
        return this.sprintToProjects;
    }
}

