/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.callback;

import com.atlassian.greenhopper.service.issue.callback.AbstractIssueDataCallback;
import com.atlassian.greenhopper.util.NumberUtils;
import com.atlassian.jira.issue.fields.CustomField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SprintAndIssueIdsCallback
extends AbstractIssueDataCallback {
    private final String documentId;
    private final Map<Long, List<Long>> sprintToIssues;

    public SprintAndIssueIdsCallback(CustomField sprintCustomField) {
        this.documentId = sprintCustomField.getId();
        this.sprintToIssues = new LinkedHashMap<Long, List<Long>>();
    }

    @Override
    public Set<String> getFields() {
        return Collections.singleton(this.documentId);
    }

    @Override
    public void fieldData(Long issueId, String issueKey, String fieldName, String data) {
        if (data == null) {
            return;
        }
        Long sprintId = NumberUtils.toLong(data);
        if (sprintId == null) {
            return;
        }
        List<Long> issuesForSprint = this.sprintToIssues.get(sprintId);
        if (issuesForSprint == null) {
            issuesForSprint = new ArrayList<Long>();
            this.sprintToIssues.put(sprintId, issuesForSprint);
        }
        issuesForSprint.add(issueId);
    }

    public Set<Long> getSprintIds() {
        return this.sprintToIssues.keySet();
    }

    public Map<Long, List<Long>> getSprintToIssues() {
        return this.sprintToIssues;
    }
}

