/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.callback;

import com.atlassian.greenhopper.service.issue.callback.IssueFieldValueProvider;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;

public class IssueFieldValueProviderImpl
implements IssueFieldValueProvider {
    public Map<String, Object> fieldValues = new HashMap<String, Object>();
    private Option<Document> issueDoc = Option.none();

    @Override
    public boolean has(String key) {
        return this.fieldValues.containsKey(key);
    }

    @Override
    public String get(String key) {
        Object val = this.fieldValues.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        return (String)((List)val).get(0);
    }

    @Override
    public List<String> getList(String key) {
        Object val = this.fieldValues.get(key);
        if (val == null) {
            return Collections.emptyList();
        }
        if (val instanceof String) {
            return Collections.singletonList((String)val);
        }
        return (List)val;
    }

    public void add(String key, String val) {
        Object previousValue = this.fieldValues.put(key, val);
        if (previousValue == null) {
            return;
        }
        if (previousValue instanceof String) {
            ArrayList<String> values = new ArrayList<String>();
            values.add((String)previousValue);
            values.add(val);
            this.fieldValues.put(key, values);
            return;
        }
        ((List)previousValue).add(val);
        this.fieldValues.put(key, previousValue);
    }

    @Override
    public Option<Document> getIssueDoc() {
        return this.issueDoc;
    }

    public void setIssueDoc(Option<Document> issueDoc) {
        this.issueDoc = issueDoc;
    }

    public void clear() {
        this.fieldValues.clear();
        this.issueDoc = Option.none();
    }
}

