/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.callback;

import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.service.issue.callback.AbstractColumnStatisticsCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueFieldValueProvider;
import com.atlassian.jira.util.collect.CollectionBuilder;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class IssueCountExcludingSubTasksStatisticsCallback
extends AbstractColumnStatisticsCallback {
    private final Set<String> parentIssueTypeIds;

    public IssueCountExcludingSubTasksStatisticsCallback(Map<String, Column> columnsByStatusId, Set<String> parentIssueTypeIds) {
        super(columnsByStatusId);
        this.parentIssueTypeIds = parentIssueTypeIds;
    }

    @Override
    @Nonnull
    protected Double getStatisticsValue(Long issueId, String issueKey, IssueFieldValueProvider data) {
        String issueType = data.get("type");
        return this.parentIssueTypeIds.contains(issueType) ? 1.0 : 0.0;
    }

    @Override
    public Set<String> getFields() {
        return CollectionBuilder.newBuilder().addAll(super.getFields()).add((Object)"type").asSet();
    }
}

