/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.callback;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.joda.time.DateTime;

public class IssueCountAndLastUpdatedCollector
extends SimpleCollector {
    private static final long NULL_DATE_IN_LUCENE = Long.MAX_VALUE;
    private long lastUpdatedDate = 0L;
    private int issueCount = 0;
    private NumericDocValues docIdToUpdatedDateValues;

    public void setScorer(Scorer scorer) {
    }

    public void collect(int docId) throws IOException {
        long updatedDate;
        ++this.issueCount;
        if (this.docIdToUpdatedDateValues.advanceExact(docId) && Long.MAX_VALUE != (updatedDate = this.docIdToUpdatedDateValues.longValue())) {
            this.lastUpdatedDate = Math.max(this.lastUpdatedDate, updatedDate);
        }
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docIdToUpdatedDateValues = context.reader().getNumericDocValues("sort_updated");
    }

    public boolean needsScores() {
        return false;
    }

    public int getIssueCount() {
        return this.issueCount;
    }

    public DateTime getLastUpdatedDate() {
        return new DateTime(this.lastUpdatedDate);
    }
}

