/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.callback;

import com.atlassian.greenhopper.service.issue.callback.AbstractIssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueDataCallback;
import com.atlassian.jira.util.collect.CollectionBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class IssueAndParentKeyCallback
extends AbstractIssueDataCallback
implements IssueDataCallback {
    private final Map<String, String> issueKeyToParentIdMap = new HashMap<String, String>();
    private final Map<String, String> issueIdToKeyMap = new HashMap<String, String>();
    private Map<String, String> issueKeyToParentKeyMap = null;

    @Override
    public Set<String> getFields() {
        return CollectionBuilder.newBuilder((Object[])new String[]{"issue_parenttask"}).asSet();
    }

    @Override
    public void fieldData(Long issueId, String issueKey, String fieldName, String parentId) {
        this.issueIdToKeyMap.put(issueId.toString(), issueKey);
        if (StringUtils.isEmpty((CharSequence)parentId)) {
            this.issueKeyToParentIdMap.put(issueKey, null);
        } else {
            this.issueKeyToParentIdMap.put(issueKey, parentId);
        }
    }

    public Map<String, String> getIssueToParentKeyMap() {
        if (this.issueKeyToParentKeyMap == null) {
            HashMap<String, String> localIssueKeyToParentKeyMap = new HashMap<String, String>();
            for (Map.Entry<String, String> issue : this.issueIdToKeyMap.entrySet()) {
                String issueKey = issue.getValue();
                String parentId = this.issueKeyToParentIdMap.get(issueKey);
                if (parentId == null) {
                    localIssueKeyToParentKeyMap.put(issueKey, null);
                    continue;
                }
                String parentKey = this.issueIdToKeyMap.get(parentId);
                localIssueKeyToParentKeyMap.put(issueKey, parentKey);
            }
            this.issueKeyToParentKeyMap = Collections.unmodifiableMap(localIssueKeyToParentKeyMap);
        }
        return this.issueKeyToParentKeyMap;
    }
}

