/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.callback;

import com.atlassian.greenhopper.customfield.CustomFieldUtil;
import com.atlassian.greenhopper.service.issue.callback.IssueFieldValueProvider;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryCallbackComponent;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.Set;

public class FlaggingCallbackComponent
implements RapidIssueEntryCallbackComponent {
    private final String luceneFieldId;
    private final Options availableOptions;

    public FlaggingCallbackComponent(CustomField flaggingField) {
        this.luceneFieldId = flaggingField.getId();
        Option<FieldConfig> config = CustomFieldUtil.getOneAndOnlyConfig(flaggingField);
        Option<Options> customFieldOptions = CustomFieldUtil.getCustomFieldOptions(flaggingField, config);
        this.availableOptions = (Options)customFieldOptions.getOrNull();
    }

    @Override
    public Set<String> getFields() {
        return Collections.singleton(this.luceneFieldId);
    }

    @Override
    public void processFieldData(Long issueId, String issueKey, IssueFieldValueProvider data, RapidIssueEntry entry) {
        String dataValue;
        if (this.availableOptions != null && data.has(this.luceneFieldId) && (dataValue = data.get(this.luceneFieldId)) != null && this.availableOptions.getOptionById(Long.valueOf(dataValue)) != null) {
            entry.flagged = true;
        }
    }
}

