/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.callback;

import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.service.issue.callback.AbstractCompoundDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueFieldValueProvider;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.jira.util.collect.CollectionBuilder;
import io.atlassian.fugue.Option;
import java.util.HashSet;
import java.util.Set;

public class EstimatableIssueDataCallback
extends AbstractCompoundDataCallback {
    private final EstimateStatisticService estimateStatisticService;
    private final StatisticsField statisticsField;
    private final Option<Set<String>> maybeAllIssueKeys;
    private Set<String> estimatableIssues;

    public EstimatableIssueDataCallback(EstimateStatisticService estimateStatisticService, StatisticsField statisticsField, Option<Set<String>> maybeAllIssueKeys) {
        this.estimateStatisticService = estimateStatisticService;
        this.statisticsField = statisticsField;
        this.maybeAllIssueKeys = maybeAllIssueKeys;
        this.estimatableIssues = new HashSet<String>();
    }

    @Override
    public Set<String> getFields() {
        return CollectionBuilder.newBuilder((Object[])new String[]{"key", "projid", "type"}).asSet();
    }

    @Override
    protected void fieldData(Long issueId, String issueKey, IssueFieldValueProvider issueFieldValueProvider) {
        if ((this.maybeAllIssueKeys.isEmpty() || ((Set)this.maybeAllIssueKeys.get()).contains(issueKey)) && !this.estimatableIssues.contains(issueKey)) {
            boolean isIssueEstimatable;
            boolean bl = isIssueEstimatable = !this.estimateStatisticService.isEstimateStatisticFieldAndNotApplicable(this.statisticsField, Long.valueOf(issueFieldValueProvider.get("projid")), issueFieldValueProvider.get("type"));
            if (isIssueEstimatable) {
                this.estimatableIssues.add(issueKey);
            }
        }
    }

    public Set<String> getEstimatableIssueKeys() {
        return this.estimatableIssues;
    }
}

