/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.callback;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.issue.callback.AbstractIssueDataCallback;
import com.atlassian.greenhopper.service.issuelink.EpicModel;
import com.atlassian.greenhopper.service.issuelink.EpicNamesResult;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class EpicLabelAndKeyMatchingCallback
extends AbstractIssueDataCallback {
    private final Map<String, String> issues;
    private final String searchTerm;
    private final String epicLabelCustomFieldId;
    private final String epicStatusCustomFieldId;
    private final String epicDoneStatusValue;
    private boolean hideDone = false;
    private final boolean filterEpicByGivenProjects;
    private final List<String> prioritizedProjectKeys;
    private int maxResults;
    private int totalMatches = 0;
    private final List<String> prioritizedIssues;
    private final Set<String> doneIssues;
    private final I18n2 i18n2;

    private EpicLabelAndKeyMatchingCallback(String epicLabelCustomFieldId, String searchTerm, int maxResults, String epicStatusCustomFieldId, String epicDoneStatusValue, boolean hideDone, List<String> prioritizedProjectKeys, I18n2 i18n2, boolean filterEpicByGivenProjects) {
        super(epicLabelCustomFieldId, epicStatusCustomFieldId, "projkey");
        this.epicLabelCustomFieldId = epicLabelCustomFieldId;
        this.epicStatusCustomFieldId = epicStatusCustomFieldId;
        this.epicDoneStatusValue = epicDoneStatusValue;
        this.hideDone = hideDone;
        this.filterEpicByGivenProjects = filterEpicByGivenProjects;
        this.searchTerm = Strings.nullToEmpty((String)searchTerm).toUpperCase();
        this.maxResults = maxResults;
        this.prioritizedProjectKeys = Optional.ofNullable(prioritizedProjectKeys).orElse(Collections.emptyList());
        this.i18n2 = i18n2;
        this.issues = Maps.newLinkedHashMap();
        this.prioritizedIssues = Lists.newArrayList();
        this.doneIssues = new HashSet<String>();
    }

    @Override
    public void fieldData(Long issueId, String issueKey, String fieldName, String data) {
        if (fieldName.equalsIgnoreCase(this.epicLabelCustomFieldId)) {
            if (this.searchTerm.contains(",")) {
                String[] searchTermInDetails;
                for (String subTerm : searchTermInDetails = this.searchTerm.split(",")) {
                    this.putToResultMap(issueKey, data, subTerm);
                }
            } else {
                this.putToResultMap(issueKey, data, this.searchTerm);
            }
        } else if (fieldName.equalsIgnoreCase(this.epicStatusCustomFieldId) && this.epicDoneStatusValue.equalsIgnoreCase(data)) {
            this.doneIssues.add(issueKey);
        } else if (fieldName.equalsIgnoreCase("projkey") && this.prioritizedProjectKeys.stream().anyMatch(projectKey -> projectKey.equalsIgnoreCase(data))) {
            this.prioritizedIssues.add(issueKey);
        }
    }

    private void putToResultMap(String issueKey, String issueLabel, String subTerm) {
        if (this.issues.containsKey(issueKey)) {
            return;
        }
        if (this.doesIssueBelongToGivenProject(issueKey) && (EpicLabelAndKeyMatchingCallback.doesIssueLabelMatchWithGivenTerm(issueLabel, subTerm) || EpicLabelAndKeyMatchingCallback.doesIssueKeyMatchWithGivenTerm(issueKey, subTerm))) {
            this.issues.put(issueKey, issueLabel);
            ++this.totalMatches;
        }
    }

    private boolean doesIssueBelongToGivenProject(String issueKey) {
        if (CollectionUtils.isEmpty(this.prioritizedProjectKeys) || !this.filterEpicByGivenProjects) {
            return true;
        }
        return this.prioritizedProjectKeys.stream().anyMatch(projectKey -> StringUtils.containsIgnoreCase((CharSequence)issueKey, (CharSequence)projectKey));
    }

    private static boolean doesIssueLabelMatchWithGivenTerm(String issueLabel, String subTerm) {
        return StringUtils.containsIgnoreCase((CharSequence)issueLabel, (CharSequence)subTerm.trim());
    }

    private static boolean doesIssueKeyMatchWithGivenTerm(String issueKey, String subTerm) {
        return StringUtils.containsIgnoreCase((CharSequence)issueKey, (CharSequence)subTerm.trim());
    }

    public List<EpicNamesResult> getIssues() {
        ArrayList<EpicNamesResult> result = new ArrayList<EpicNamesResult>(2);
        Map filteredPrioritizedIssues = this.prioritizedIssues.stream().filter(issueKey -> this.issues.containsKey(issueKey) && this.validStatus((String)issueKey)).collect(HashMap::new, (map, key) -> map.put(key, this.issues.get(key)), HashMap::putAll);
        if (!filteredPrioritizedIssues.isEmpty()) {
            EpicNamesResult prioritized = new EpicNamesResult();
            prioritized.setNames((Collection)Lists.partition(this.orderEpicByName(filteredPrioritizedIssues), (int)this.maxResults).get(0));
            prioritized.setListDescriptor(this.i18n2.getText("gh.epic.link.picker.suggestions"));
            prioritized.setTotal(this.getTotalMatches());
            result.add(prioritized);
            if (this.prioritizedIssues.size() >= this.maxResults) {
                return result;
            }
        }
        List<EpicModel> allIssues = this.orderEpicByName(this.issues).stream().filter(epicModel -> !filteredPrioritizedIssues.containsKey(epicModel.getEpicKey()) && this.validStatus(epicModel.getEpicKey())).limit(this.maxResults - filteredPrioritizedIssues.size()).collect(Collectors.toList());
        EpicNamesResult all = new EpicNamesResult();
        all.setNames(allIssues);
        all.setListDescriptor(this.i18n2.getText("gh.epic.link.picker.allepics"));
        all.setTotal(this.getTotalMatches());
        result.add(all);
        return result;
    }

    private boolean validStatus(String key) {
        return !this.hideDone || !this.doneIssues.contains(key);
    }

    private List<EpicModel> orderEpicByName(Map<String, String> epicList) {
        List<EpicModel> epicModelList = Lists.newArrayList(epicList.entrySet()).stream().map(entry -> new EpicModel((String)entry.getKey(), (String)entry.getValue(), this.doneIssues.contains(entry.getKey()))).collect(Collectors.toList());
        Collections.sort(epicModelList, (firstModel, secondModel) -> {
            if (firstModel.getEpicName() == null) {
                if (secondModel.getEpicName() == null) {
                    return firstModel.getEpicKey().compareToIgnoreCase(secondModel.getEpicKey());
                }
                return 1;
            }
            if (secondModel.getEpicName() == null) {
                return -1;
            }
            int lastCmp = firstModel.getEpicName().compareToIgnoreCase(secondModel.getEpicName());
            return lastCmp != 0 ? lastCmp : firstModel.getEpicKey().compareToIgnoreCase(secondModel.getEpicKey());
        });
        return epicModelList;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    private int getTotalMatches() {
        int totalDoneStatusMatches = Math.toIntExact(this.doneIssues.stream().filter(issueKey -> this.issues.containsKey(issueKey)).count());
        return this.hideDone ? this.totalMatches - totalDoneStatusMatches : this.totalMatches;
    }

    public static class Builder {
        private String epicLabelCustomFieldId;
        private String epicStatusCustomFieldId;
        private String epicDoneStatusValue;
        private I18n2 i18n2;
        private String searchTerm = "";
        private List<String> prioritizedProjectKeys = Collections.emptyList();
        private boolean hideDone = false;
        private boolean filterEpicByGivenProjects = false;
        private int maxResults = 100;

        public static Builder newBuilder() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder epicLabelCustomFieldId(String epicLabelCustomFieldId) {
            this.epicLabelCustomFieldId = epicLabelCustomFieldId;
            return this;
        }

        public Builder epicStatusCustomField(String epicStatusCustomFieldId) {
            this.epicStatusCustomFieldId = epicStatusCustomFieldId;
            return this;
        }

        public Builder epicDoneStatusValue(String epicDoneStatusValue) {
            this.epicDoneStatusValue = epicDoneStatusValue;
            return this;
        }

        public Builder i18n2(I18n2 i18n2) {
            this.i18n2 = i18n2;
            return this;
        }

        public Builder searchTerm(String searchTerm) {
            this.searchTerm = searchTerm;
            return this;
        }

        public Builder projectKeys(List<String> prioritizedProjectKeys) {
            this.prioritizedProjectKeys = prioritizedProjectKeys;
            return this;
        }

        public Builder maxResults(int maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public Builder hideDone(boolean hideDone) {
            this.hideDone = hideDone;
            return this;
        }

        public Builder filterEpicByGivenProjects(boolean filterEpicByGivenProjects) {
            this.filterEpicByGivenProjects = filterEpicByGivenProjects;
            return this;
        }

        public EpicLabelAndKeyMatchingCallback build() {
            this.assertAllEssentialFieldsNotNull();
            return new EpicLabelAndKeyMatchingCallback(this.epicLabelCustomFieldId, this.searchTerm, this.maxResults, this.epicStatusCustomFieldId, this.epicDoneStatusValue, this.hideDone, this.prioritizedProjectKeys, this.i18n2, this.filterEpicByGivenProjects);
        }

        private void assertAllEssentialFieldsNotNull() {
            Optional.ofNullable(this.epicLabelCustomFieldId).orElseThrow(() -> new IllegalArgumentException("epicLabelCustomFieldId must not be null"));
            Optional.ofNullable(this.epicStatusCustomFieldId).orElseThrow(() -> new IllegalArgumentException("epicStatusCustomFieldId must not be null"));
            Optional.ofNullable(this.epicDoneStatusValue).orElseThrow(() -> new IllegalArgumentException("epicDoneStatusValue must not be null"));
            Optional.ofNullable(this.i18n2).orElseThrow(() -> new IllegalArgumentException("i18n2 must not be null"));
        }
    }
}

