/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.callback;

import com.atlassian.greenhopper.service.issue.callback.IssueDataCallback;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;

public class ComposedIssueDataCallback
implements IssueDataCallback {
    private final List<? extends IssueDataCallback> composites;
    private final Set<String> allFields;
    private boolean requiresIssueDoc;

    public static <T extends IssueDataCallback> ComposedIssueDataCallback of(T ... composites) {
        List<T> ts = Arrays.asList(composites);
        return new ComposedIssueDataCallback(ts);
    }

    private ComposedIssueDataCallback(List<? extends IssueDataCallback> composites) {
        this.composites = composites;
        this.allFields = new HashSet<String>();
        for (IssueDataCallback issueDataCallback : composites) {
            this.allFields.addAll(issueDataCallback.getFields());
            if (!issueDataCallback.requiresIssueDoc()) continue;
            this.requiresIssueDoc = true;
        }
    }

    @Override
    public Set<String> getFields() {
        return this.allFields;
    }

    @Override
    public boolean requiresIssueDoc() {
        return this.requiresIssueDoc;
    }

    @Override
    public void fieldData(Long issueId, String issueKey, String fieldName, String data) {
        for (IssueDataCallback issueDataCallback : this.composites) {
            if (!issueDataCallback.getFields().contains(fieldName)) continue;
            issueDataCallback.fieldData(issueId, issueKey, fieldName, data);
        }
    }

    @Override
    public void issueComplete(Long issueId, String issueKey, Option<Document> issueDoc) {
        for (IssueDataCallback issueDataCallback : this.composites) {
            issueDataCallback.issueComplete(issueId, issueKey, issueDoc);
        }
    }
}

