/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.callback;

import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.issue.callback.AbstractColumnStatisticsCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueCountExcludingSubTasksStatisticsCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueCountStatisticsCallback;
import com.atlassian.greenhopper.service.issue.callback.JiraFieldStatisticsCallback;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.StatisticsFieldService;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ColumnStatisticsCallbackFactory {
    @Autowired
    private ColumnService columnService;
    @Autowired
    private IssueTypeManager issueTypeManager;
    @Autowired
    private StatisticsFieldService statisticsFieldService;

    @Nonnull
    public Option<AbstractColumnStatisticsCallback> createCallback(RapidView rapidView) {
        ServiceOutcome<StatisticsFieldConfig> statisticsFieldConfig = this.statisticsFieldService.loadStatisticsField(rapidView);
        if (!statisticsFieldConfig.isValid() || statisticsFieldConfig.getValue().getType() == StatisticsFieldConfig.Type.NONE) {
            return Option.none();
        }
        return Option.some((Object)this.createCallback(rapidView, statisticsFieldConfig.getValue()));
    }

    @Nonnull
    public AbstractColumnStatisticsCallback createCallback(RapidView rapidView, StatisticsFieldConfig statisticsField) {
        Map<Status, Column> columnsByStatus = this.columnService.getColumnsByStatus(rapidView);
        HashMap<String, Column> columnsByStatusId = new HashMap<String, Column>();
        for (Map.Entry<Status, Column> entry : columnsByStatus.entrySet()) {
            columnsByStatusId.put(entry.getKey().getId(), entry.getValue());
        }
        switch (statisticsField.getType()) {
            case ISSUE_COUNT_EXCL_SUBS: {
                HashSet<String> parentIssueTypeIds = new HashSet<String>();
                Collection issueTypes = this.issueTypeManager.getIssueTypes();
                for (IssueType issueType : issueTypes) {
                    if (issueType.isSubTask()) continue;
                    parentIssueTypeIds.add(issueType.getId());
                }
                return new IssueCountExcludingSubTasksStatisticsCallback(columnsByStatusId, parentIssueTypeIds);
            }
            case ISSUE_COUNT: {
                return new IssueCountStatisticsCallback(columnsByStatusId);
            }
            case JIRA_FIELD: {
                return new JiraFieldStatisticsCallback(columnsByStatusId, statisticsField);
            }
        }
        throw new IllegalArgumentException("Unknown statistics field type " + (Object)((Object)statisticsField.getType()));
    }
}

