/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue.callback;

import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.service.issue.callback.AbstractCompoundDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueFieldValueProvider;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryCallbackComponent;
import com.atlassian.jira.util.collect.CollectionBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class AbstractColumnStatisticsCallback
extends AbstractCompoundDataCallback
implements RapidIssueEntryCallbackComponent {
    private final Map<String, Column> columnsByStatusId;
    private final Map<Column, Double> statisticsValuesByColumn;

    public AbstractColumnStatisticsCallback(Map<String, Column> columnsByStatusId) {
        this.columnsByStatusId = columnsByStatusId;
        this.statisticsValuesByColumn = new HashMap<Column, Double>();
        for (Column column : columnsByStatusId.values()) {
            this.statisticsValuesByColumn.put(column, 0.0);
        }
    }

    @Override
    public Set<String> getFields() {
        return CollectionBuilder.newBuilder((Object[])new String[]{"status"}).asSet();
    }

    @Override
    protected void fieldData(Long issueId, String issueKey, IssueFieldValueProvider data) {
        String status = data.get("status");
        Double statsValue = this.getStatisticsValue(issueId, issueKey, data);
        if (this.columnsByStatusId.containsKey(status)) {
            Column column = this.columnsByStatusId.get(status);
            this.statisticsValuesByColumn.put(column, this.statisticsValuesByColumn.get(column) + statsValue);
        }
    }

    @Override
    public void processFieldData(Long issueId, String issueKey, IssueFieldValueProvider data, RapidIssueEntry entry) {
        Double value = this.getStatisticsValue(issueId, issueKey, data);
        entry.columnStatistic = new RapidIssueEntry.StatisticFieldValue(StatisticsFieldConfig.Type.ISSUE_COUNT_EXCL_SUBS.getId(), new RapidIssueEntry.NumberFieldValue(value));
    }

    @Nonnull
    protected abstract Double getStatisticsValue(Long var1, String var2, IssueFieldValueProvider var3);

    public Map<Column, Double> getStatisticsValuesByColumn() {
        return this.statisticsValuesByColumn;
    }
}

