/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.issue.index.FindQueriesMatchingIssue;
import com.atlassian.greenhopper.jira.JIRAResource;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.SearchService;
import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.query.LuceneQueryBuilder;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.TopDocs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchServiceImpl
implements SearchService {
    @Autowired
    private com.atlassian.jira.bc.issue.search.SearchService jiraSearchService;
    @Autowired
    private SearchProviderFactory searchProviderFactory;
    @Autowired
    private FindQueriesMatchingIssue findQueriesMatchingIssueAdapter;
    @JIRAResource
    private LuceneQueryBuilder luceneQueryBuilder;
    private final LoggerWrapper log = LoggerWrapper.with(this.getClass());

    @Override
    @Nonnull
    public ServiceOutcome<Iterable<Issue>> findOne(ApplicationUser user, Query query) {
        PagerFilter pager = PagerFilter.newPageAlignedFilter((int)0, (int)1);
        try {
            SearchResults results = this.jiraSearchService.search(user, query, pager);
            if (results.getResults().size() > 1) {
                return this.searchError(new IllegalArgumentException("More than one issue found"));
            }
            return ServiceOutcomeImpl.ok(results.getResults());
        }
        catch (SearchException e) {
            return this.searchError((Exception)((Object)e));
        }
    }

    @Override
    @Nonnull
    public ServiceOutcome<SearchResults<Issue>> search(ApplicationUser user, Query query) {
        return this.search(user, query, false);
    }

    @Override
    @Nonnull
    public ServiceOutcome<SearchResults<Issue>> searchOverrideSecurity(ApplicationUser user, Query query) {
        return this.search(user, query, true);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Set<Query>> findQueriesMatchingIssue(@Nonnull ApplicationUser user, @Nonnull Map<Issue, Collection<Query>> issuesAndQueries) {
        try {
            return ServiceOutcomeImpl.ok(this.findQueriesMatchingIssueAdapter.findQueries(user, issuesAndQueries));
        }
        catch (SearchException e) {
            return this.searchError((Exception)((Object)e));
        }
    }

    @Override
    @Nonnull
    public ServiceOutcome<org.apache.lucene.search.Query> buildLuceneQuery(QueryCreationContext queryCreationContext, Query baseQuery, Option<org.apache.lucene.search.Query> andQuery) {
        try {
            Object baseQueryConverted = baseQuery == null || baseQuery.getWhereClause() == null ? new MatchAllDocsQuery() : this.luceneQueryBuilder.createLuceneQuery(queryCreationContext, baseQuery.getWhereClause());
            if (andQuery.isEmpty()) {
                return ServiceOutcomeImpl.ok(baseQueryConverted);
            }
            BooleanQuery.Builder result = new BooleanQuery.Builder();
            result.add((org.apache.lucene.search.Query)baseQueryConverted, BooleanClause.Occur.MUST);
            result.add((org.apache.lucene.search.Query)andQuery.get(), BooleanClause.Occur.MUST);
            return ServiceOutcomeImpl.ok(result.build());
        }
        catch (SearchException e) {
            return this.searchError((Exception)((Object)e));
        }
    }

    @Override
    @Nonnull
    public ServiceOutcome<Long> searchCount(ApplicationUser user, Query query) {
        try {
            Long count = this.jiraSearchService.searchCount(user, query);
            return ServiceOutcomeImpl.ok(count);
        }
        catch (SearchException e) {
            return this.searchError((Exception)((Object)e));
        }
    }

    @Override
    @Nonnull
    public ServiceOutcome<Long> searchCountOverrideSecurity(ApplicationUser user, Query query) {
        try {
            long result = this.jiraSearchService.searchCountOverrideSecurity(user, query);
            return ServiceOutcomeImpl.ok(result);
        }
        catch (SearchException e) {
            return this.searchError((Exception)((Object)e));
        }
    }

    @Override
    @Nonnull
    public ServiceOutcome<Long> searchCountOverrideSecurity(ApplicationUser user, org.apache.lucene.search.Query query) {
        ManagedIndexSearcher issueSearcher = this.searchProviderFactory.getSearcher("issues");
        if (query == null) {
            query = new MatchAllDocsQuery();
        }
        try {
            TopDocs search = issueSearcher.search(query, Integer.MAX_VALUE);
            return ServiceOutcomeImpl.ok(search.totalHits);
        }
        catch (IOException ioe) {
            return this.searchError(ioe);
        }
    }

    @Nonnull
    private ServiceOutcome<SearchResults<Issue>> search(ApplicationUser user, Query query, boolean overrideSecurity) {
        PagerFilter pager = PagerFilter.getUnlimitedFilter();
        try {
            SearchResults results = overrideSecurity ? this.jiraSearchService.searchOverrideSecurity(user, query, pager) : this.jiraSearchService.search(user, query, pager);
            return ServiceOutcomeImpl.ok(results);
        }
        catch (SearchException e) {
            return this.searchError((Exception)((Object)e));
        }
    }

    private <T> ServiceOutcome<T> searchError(Exception e) {
        this.log.exception(e);
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.search.exception", new Object[0]);
    }

    @Override
    @Nonnull
    public ServiceOutcome<String> getJqlString(Query query) {
        String jqlQuery = this.jiraSearchService.getJqlString(query);
        return ServiceOutcomeImpl.ok(jqlQuery);
    }
}

