/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue;

import com.atlassian.cache.Supplier;
import com.atlassian.greenhopper.model.Epic;
import com.atlassian.greenhopper.model.rapid.EstimationConfig;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.atlassian.greenhopper.service.Pages;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.FieldValue;
import com.atlassian.greenhopper.service.issue.IssueUpdateService;
import com.atlassian.greenhopper.service.issue.RapidViewIssue;
import com.atlassian.greenhopper.service.issue.RapidViewIssueService;
import com.atlassian.greenhopper.service.issue.SearchService;
import com.atlassian.greenhopper.service.issue.flagging.FlagService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.issuelink.EpicService;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewConfigService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.greenhopper.web.rapid.issue.IssueEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldUpdatedEntry;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.query.Query;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class RapidViewIssueServiceImpl
implements RapidViewIssueService {
    @Autowired
    private SearchService searchService;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    @Autowired
    private SprintCustomFieldService sprintCustomFieldService;
    @Autowired
    private FlagService flagService;
    @Autowired
    private EpicService epicService;
    @Autowired
    private IssueService issueService;
    @Autowired
    private IssueEntryFactory issueEntryFactory;
    @Autowired
    private RapidViewConfigService rapidViewConfigService;
    @Autowired
    private IssueUpdateService issueUpdateService;

    @Override
    public ServiceOutcome<Page<RapidViewIssue>> getIssuesForRapidView(@Nullable ApplicationUser user, RapidView rapidView, PageRequest request, @Nullable Query query) {
        ServiceOutcome<Query> boardQuery = this.rapidViewQueryService.getFullRapidViewQuery(user, rapidView);
        if (!boardQuery.isValid()) {
            return ServiceOutcomeImpl.error(boardQuery);
        }
        Query fullQuery = this.rapidViewQueryService.joinQueries(boardQuery.get(), query);
        return this.getIssuesForQuery(user, request, fullQuery);
    }

    @Override
    public ServiceOutcome<Page<RapidViewIssue>> getIssuesForBacklog(@Nullable ApplicationUser user, RapidView rapidView, PageRequest request, @Nullable Query query) {
        if (!rapidView.isSprintSupportEnabled()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.kanban.error.view.does.not.support.backlog", new Object[0]);
        }
        ServiceOutcome<Query> backlogQuery = this.rapidViewQueryService.getRapidViewBacklogQuery(user, rapidView);
        if (!backlogQuery.isValid()) {
            return ServiceOutcomeImpl.error(backlogQuery);
        }
        Query fullQuery = this.rapidViewQueryService.joinQueries(backlogQuery.get(), query);
        return this.getIssuesForQuery(user, request, fullQuery);
    }

    @Override
    public ServiceOutcome<Page<RapidViewIssue>> getIssuesForSprint(@Nullable ApplicationUser user, Sprint sprint, PageRequest request, @Nullable Query query) {
        ServiceOutcome<Query> backlogQuery = this.rapidViewQueryService.getSprintQuery(user, sprint);
        if (!backlogQuery.isValid()) {
            return ServiceOutcomeImpl.error(backlogQuery);
        }
        Query fullQuery = this.rapidViewQueryService.joinQueries(backlogQuery.get(), query);
        return this.getIssuesForQuery(user, request, fullQuery);
    }

    @Override
    public ServiceOutcome<Page<RapidViewIssue>> getIssuesForSprintInBoardContext(@Nullable ApplicationUser user, RapidView rapidView, Sprint sprint, PageRequest request, @Nullable Query query) {
        if (!rapidView.isSprintSupportEnabled()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.kanban.error.view.does.not.support.sprints", new Object[0]);
        }
        ServiceOutcome<Query> backlogQuery = this.rapidViewQueryService.getSprintQueryInBoardContext(user, rapidView, sprint);
        if (!backlogQuery.isValid()) {
            return ServiceOutcomeImpl.error(backlogQuery);
        }
        Query fullQuery = this.rapidViewQueryService.joinQueries(backlogQuery.get(), query);
        return this.getIssuesForQuery(user, request, fullQuery);
    }

    @Override
    public ServiceOutcome<Page<RapidViewIssue>> getIssuesForEpic(@Nullable ApplicationUser user, RapidView rapidView, Epic epic, PageRequest request, @Nullable Query query) {
        return this.getIssuesForMainAndOptionalQuery(user, request, query, (Supplier<ServiceOutcome<Query>>)((Supplier)() -> this.rapidViewQueryService.getEpicQueryInBoardContext(user, rapidView, epic)));
    }

    @Override
    public ServiceOutcome<Page<RapidViewIssue>> getIssuesWithoutEpic(@Nullable ApplicationUser user, @Nonnull RapidView rapidView, @Nonnull PageRequest request, @Nullable Query query) {
        return this.getIssuesForMainAndOptionalQuery(user, request, query, (Supplier<ServiceOutcome<Query>>)((Supplier)() -> this.rapidViewQueryService.getIssuesWithoutEpicQueryInBoardContext(user, rapidView)));
    }

    @Override
    public ServiceOutcome<Page<RapidViewIssue>> getIssuesForEpic(@Nullable ApplicationUser user, Epic epic, PageRequest request, @Nullable Query query) {
        return this.getIssuesForMainAndOptionalQuery(user, request, query, (Supplier<ServiceOutcome<Query>>)((Supplier)() -> this.rapidViewQueryService.getEpicQuery(user, epic)));
    }

    @Override
    public ServiceOutcome<Page<RapidViewIssue>> getIssuesWithoutEpic(@Nullable ApplicationUser user, PageRequest request, @Nullable Query query) {
        return this.getIssuesForMainAndOptionalQuery(user, request, query, (Supplier<ServiceOutcome<Query>>)((Supplier)() -> this.rapidViewQueryService.getIssuesWithoutEpicQuery(user)));
    }

    @Override
    public ServiceOutcome<RapidViewIssue> getIssueById(@Nullable ApplicationUser user, Long issueId) {
        IssueService.IssueResult issue = this.issueService.getIssue(user, issueId);
        return this.getRapidViewIssueFromIssueResult(user, issue);
    }

    @Override
    public ServiceOutcome<RapidViewIssue> getIssueByKey(@Nullable ApplicationUser user, IssueKey issueKey) {
        IssueService.IssueResult issue = this.issueService.getIssue(user, issueKey.toString());
        return this.getRapidViewIssueFromIssueResult(user, issue);
    }

    @Override
    public ServiceOutcome<FieldValue> getIssueEstimationForBoard(@Nullable ApplicationUser user, @Nonnull Issue issue, @Nonnull RapidView rapidView) {
        ServiceOutcome<Field> estimationFieldForBoard = this.getEstimationFieldForBoard(user, rapidView);
        if (!this.isIssueOnBoard(user, rapidView, issue)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.error.issue.no.view.from.board", issue.getKey(), rapidView.getName());
        }
        if (!estimationFieldForBoard.isValid()) {
            return ServiceOutcomeImpl.error(estimationFieldForBoard);
        }
        String fieldId = estimationFieldForBoard.get().getId();
        Object fieldValue = this.getValueForField(estimationFieldForBoard.get(), issue);
        return ServiceOutcomeImpl.ok(new FieldValue(fieldId, fieldValue));
    }

    @Override
    public ServiceOutcome<FieldValue> estimateIssueForBoard(@Nullable ApplicationUser user, @Nonnull Issue issue, @Nonnull RapidView rapidView, @Nonnull String value) {
        ServiceOutcome<Field> estimationFieldForBoard = this.getEstimationFieldForBoard(user, rapidView);
        if (!estimationFieldForBoard.isValid()) {
            return ServiceOutcomeImpl.error(estimationFieldForBoard);
        }
        if (!this.isIssueOnBoard(user, rapidView, issue)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.error.issue.no.view.from.board", issue.getKey(), rapidView.getName());
        }
        if (!this.issueUpdateService.canEditField(issue, estimationFieldForBoard.get())) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.error.field.not.editable.on.issue", issue.getKey(), rapidView.getName());
        }
        String fieldId = estimationFieldForBoard.get().getId();
        ServiceOutcome<FieldUpdatedEntry> fieldUpdated = this.issueEntryFactory.updateField(user, issue, fieldId, value);
        if (!fieldUpdated.isValid()) {
            return ServiceOutcomeImpl.error(fieldUpdated);
        }
        IssueService.IssueResult updatedIssue = this.issueService.getIssue(user, issue.getId());
        if (!updatedIssue.isValid()) {
            return ServiceOutcomeImpl.fromJiraErrorCollectionWithReasons(updatedIssue.getErrorCollection());
        }
        Object fieldValue = this.getValueForField(estimationFieldForBoard.get(), (Issue)updatedIssue.getIssue());
        return ServiceOutcomeImpl.ok(new FieldValue(fieldId, fieldValue));
    }

    @Nullable
    private Object getValueForField(Field field, Issue issue) {
        if (field instanceof RestAwareField) {
            RestAwareField restAwareField = (RestAwareField)field;
            JsonData standardData = restAwareField.getJsonFromIssue(issue, false, null).getStandardData();
            return standardData != null ? standardData.getData() : null;
        }
        return null;
    }

    private boolean isIssueOnBoard(@Nullable ApplicationUser user, RapidView rapidView, Issue issue) {
        ServiceOutcome<Query> boardQuery = this.rapidViewQueryService.getFullRapidViewQuery(user, rapidView);
        if (!boardQuery.isValid()) {
            return false;
        }
        ServiceOutcome<SearchResults<Issue>> search = this.searchService.search(user, boardQuery.get());
        if (!search.isValid()) {
            return false;
        }
        List issues = search.get().getResults();
        return issues.stream().anyMatch(boardIssue -> boardIssue.equals((Object)issue));
    }

    private ServiceOutcome<Field> getEstimationFieldForBoard(@Nullable ApplicationUser user, @Nonnull RapidView rapidView) {
        EstimationConfig estimationConfig = this.rapidViewConfigService.getEstimationConfig(user, rapidView);
        if (estimationConfig == null || !estimationConfig.getType().isFieldBased().booleanValue() || estimationConfig.getField() == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.estimation.statistics.error.not.field.type", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(estimationConfig.getField());
    }

    private ServiceOutcome<Page<RapidViewIssue>> getIssuesForMainAndOptionalQuery(@Nullable ApplicationUser user, PageRequest request, @Nullable Query additionalQuery, Supplier<ServiceOutcome<Query>> mainQueryProvider) {
        ServiceOutcome epicQuery = (ServiceOutcome)mainQueryProvider.get();
        if (!epicQuery.isValid()) {
            return ServiceOutcomeImpl.error(epicQuery);
        }
        Query fullQuery = this.rapidViewQueryService.joinQueries((Query)epicQuery.get(), additionalQuery);
        return this.getIssuesForQuery(user, request, fullQuery);
    }

    private ServiceOutcome<RapidViewIssue> getRapidViewIssueFromIssueResult(@Nullable ApplicationUser user, IssueService.IssueResult issueResult) {
        if (!issueResult.isValid()) {
            ErrorCollection errorCollection = issueResult.getErrorCollection();
            ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons());
            if (worstReason.equals((Object)ErrorCollection.Reason.FORBIDDEN)) {
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.error.issue.by.key.not.found", new Object[0]);
            }
            return ServiceOutcomeImpl.fromJiraErrorCollectionWithReasons(errorCollection);
        }
        CustomField defaultEpicLinkField = this.epicCustomFieldService.getDefaultEpicLinkField();
        CustomField defaultSprintField = this.sprintCustomFieldService.getDefaultSprintField();
        RapidViewIssue rapidViewIssue = this.toRapidViewIssue(user, (Issue)issueResult.getIssue(), defaultEpicLinkField, defaultSprintField);
        return ServiceOutcomeImpl.ok(rapidViewIssue);
    }

    private ServiceOutcome<Page<RapidViewIssue>> getIssuesForQuery(@Nullable ApplicationUser user, PageRequest request, Query query) {
        ServiceOutcome<SearchResults<Issue>> search = this.searchService.search(user, query);
        if (!search.isValid()) {
            return ServiceOutcomeImpl.error(search);
        }
        List issues = search.get().getResults();
        Stream<RapidViewIssue> rapidViewIssues = this.transformToRapidViewIssues(user, issues.stream());
        return ServiceOutcomeImpl.ok(Pages.toPage(rapidViewIssues::iterator, request, Long.valueOf(search.get().getTotal())));
    }

    private Stream<RapidViewIssue> transformToRapidViewIssues(@Nullable ApplicationUser user, Stream<Issue> issues) {
        CustomField defaultEpicLinkField = this.epicCustomFieldService.getDefaultEpicLinkField();
        CustomField defaultSprintField = this.sprintCustomFieldService.getDefaultSprintField();
        return issues.map(issue -> this.toRapidViewIssue(user, (Issue)issue, defaultEpicLinkField, defaultSprintField));
    }

    private RapidViewIssue toRapidViewIssue(@Nullable ApplicationUser user, Issue issue, CustomField defaultEpicLinkField, CustomField defaultSprintField) {
        List sprints = (List)defaultSprintField.getValue(issue);
        Issue value = (Issue)defaultEpicLinkField.getValue(issue);
        Long epicId = value == null ? null : value.getId();
        return RapidViewIssue.builder(issue).epic(this.getEpic(user, epicId)).sprint(this.getCurrentSprint(sprints).orElse(null)).closedSprints(this.getClosedSprints(sprints)).flagged(this.flagService.isFlagged(issue)).build();
    }

    private Set<Sprint> getClosedSprints(@Nullable List<Sprint> sprints) {
        if (sprints == null) {
            return Collections.emptySet();
        }
        return sprints.stream().filter(Sprint::isClosed).collect(Collectors.toSet());
    }

    private Optional<Sprint> getCurrentSprint(@Nullable List<Sprint> sprints) {
        if (sprints == null) {
            return Optional.empty();
        }
        return sprints.stream().filter(sprint -> !sprint.isClosed()).findFirst();
    }

    @Nullable
    private Epic getEpic(@Nullable ApplicationUser user, @Nullable Long epicId) {
        if (epicId == null) {
            return null;
        }
        return this.epicService.getEpic(user, epicId).getValue();
    }
}

