/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.issue.IssueUpdateService;
import com.atlassian.greenhopper.service.issue.NotRequiredFieldScreenRenderLayoutItem;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.OperationContextImpl;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssueUpdateServiceImpl
implements IssueUpdateService {
    @Autowired
    private IssueService issueService;
    @Autowired
    private IssueManager issueManager;
    @Autowired
    private FieldManager fieldManager;
    @Autowired
    private FieldScreenRendererFactory fieldScreenRendererFactory;
    @Autowired
    private FieldConfigSchemeManager fieldConfigSchemeManager;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private I18nHelper.BeanFactory i18nBeanFactory;

    @Override
    public IssueService.IssueResult update(ApplicationUser user, IssueService.UpdateValidationResult updateValidationResult) {
        return this.issueService.update(user, updateValidationResult);
    }

    @Override
    public IssueService.IssueResult skipValidationAndUpdate(ApplicationUser user, Long issueId, IssueInputParameters issueInputParameters) {
        Map<String, Object> fieldValuesHolder = this.cloneFieldValuesHolder(issueInputParameters);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        MutableIssue updatedIssue = this.validateAndUpdateIssueFromFields(user, issue, issueInputParameters, fieldValuesHolder, (ErrorCollection)errorCollection, this.getI18n(user), this.getUpdateFieldScreenRenderer(user, (Issue)issue), true);
        if (errorCollection.hasAnyErrors()) {
            updatedIssue = null;
        }
        IssueService.UpdateValidationResult updateValidationResult = new IssueService.UpdateValidationResult(updatedIssue, (ErrorCollection)errorCollection, fieldValuesHolder);
        return this.issueService.update(user, updateValidationResult);
    }

    @Override
    public IssueService.UpdateValidationResult validateUpdate(ApplicationUser user, Long issueId, IssueInputParameters issueInputParameters) {
        if (issueInputParameters == null) {
            throw new IllegalArgumentException("You must provide a non-null issueInputParameters to update an issue.");
        }
        issueInputParameters.setRetainExistingValuesWhenParameterNotProvided(true);
        I18nHelper i18n = this.getI18n(user);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        Map<String, Object> fieldValuesHolder = this.cloneFieldValuesHolder(issueInputParameters);
        if (issueId == null) {
            errors.addErrorMessage(i18n.getText("issue.service.update.issue.is.null"));
            return new IssueService.UpdateValidationResult(null, (ErrorCollection)errors, fieldValuesHolder);
        }
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        if (issue == null) {
            errors.addErrorMessage(i18n.getText("issue.service.update.issue.is.null"));
            return new IssueService.UpdateValidationResult(null, (ErrorCollection)errors, fieldValuesHolder);
        }
        if (!this.hasPermissionToEdit(user, (Issue)issue, (ErrorCollection)errors)) {
            return new IssueService.UpdateValidationResult(null, (ErrorCollection)errors, fieldValuesHolder);
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        MutableIssue copiedIssue = this.issueManager.getIssueObject(issue.getId());
        MutableIssue updatedIssue = this.validateAndUpdateIssueFromFields(user, copiedIssue, issueInputParameters, fieldValuesHolder, (ErrorCollection)errorCollection, i18n, this.getUpdateFieldScreenRenderer(user, (Issue)issue), true);
        if (errorCollection.hasAnyErrors()) {
            updatedIssue = null;
            errors.addErrorCollection((ErrorCollection)errorCollection);
        }
        return new IssueService.UpdateValidationResult(updatedIssue, (ErrorCollection)errors, fieldValuesHolder);
    }

    MutableIssue validateAndUpdateIssueFromFields(ApplicationUser user, MutableIssue issue, IssueInputParameters issueInputParameters, Map<String, Object> fieldValuesHolder, ErrorCollection errorCollection, I18nHelper i18n, FieldScreenRenderer fieldScreenRenderer, boolean updateComment) {
        OperationContextImpl operationContext = new OperationContextImpl((IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION, fieldValuesHolder);
        SimpleErrorCollection localCollection = new SimpleErrorCollection();
        this.validateAndPopulateParams(user, issue, issueInputParameters, fieldValuesHolder, (OperationContext)operationContext, (ErrorCollection)localCollection, i18n, fieldScreenRenderer);
        if (!localCollection.hasAnyErrors()) {
            this.updateIssueFromFields(fieldScreenRenderer, issue, user, fieldValuesHolder, updateComment, issueInputParameters);
        } else {
            issue = null;
            errorCollection.addErrorCollection((ErrorCollection)localCollection);
        }
        return issue;
    }

    void validateAndPopulateParams(ApplicationUser user, MutableIssue issue, IssueInputParameters issueInputParameters, Map<String, Object> fieldValuesHolder, OperationContext operationContext, ErrorCollection errorCollection, I18nHelper i18n, FieldScreenRenderer fieldScreenRenderer) {
        if (issueInputParameters.getCommentValue() != null) {
            OrderableField field = (OrderableField)this.fieldManager.getField(SystemSearchConstants.forComments().getFieldId());
            field.populateFromParams(fieldValuesHolder, issueInputParameters.getActionParameters());
            field.validateParams(operationContext, errorCollection, i18n, (Issue)issue, this.getFieldScreenRendererLayoutItemForField(user, (Issue)issue, field));
        }
        boolean retainIssueValues = issueInputParameters.retainExistingValuesWhenParameterNotProvided();
        Set orderableFields = this.fieldManager.getOrderableFields();
        for (OrderableField orderableField : orderableFields) {
            CustomFieldParams fieldParams;
            if (!this.canEditField((Issue)issue, (Field)orderableField) || retainIssueValues && !issueInputParameters.isFieldPresent(orderableField.getId())) continue;
            FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem = this.getFieldScreenRenderLayoutItem(issue, orderableField, fieldScreenRenderer, true);
            orderableField.populateFromParams(fieldValuesHolder, issueInputParameters.getActionParameters());
            if (fieldValuesHolder.get(orderableField.getId()) instanceof CustomFieldParams && (fieldParams = (CustomFieldParams)fieldValuesHolder.get(orderableField.getId())) != null) {
                fieldParams.put("analytic.editing.context", (Collection)Lists.newArrayList((Object[])new String[]{"rapid-board"}));
            }
            orderableField.validateParams(operationContext, errorCollection, i18n, (Issue)issue, fieldScreenRenderLayoutItem);
        }
    }

    void updateIssueFromFields(FieldScreenRenderer fieldScreenRenderer, MutableIssue issue, ApplicationUser user, Map<String, Object> fieldValuesHolder, boolean updateComment, IssueInputParameters issueInputParameters) {
        if (updateComment) {
            this.updateIssueWithComment(issue, user, fieldValuesHolder);
        }
        Set orderableFields = this.fieldManager.getOrderableFields();
        for (OrderableField orderableField : orderableFields) {
            if (!this.canEditField((Issue)issue, (Field)orderableField) || issueInputParameters.retainExistingValuesWhenParameterNotProvided() && !issueInputParameters.isFieldPresent(orderableField.getId())) continue;
            FieldLayoutItem fieldLayoutItem = this.getFieldLayoutItem(issue, orderableField, fieldScreenRenderer);
            orderableField.updateIssue(fieldLayoutItem, issue, fieldValuesHolder);
        }
    }

    @Override
    public boolean canEditField(Issue issue, Field orderableField) {
        if (orderableField instanceof CustomField) {
            CustomField customField = (CustomField)orderableField;
            FieldConfig relevantConfig = this.fieldConfigSchemeManager.getRelevantConfig((IssueContext)issue, (ConfigurableField)customField);
            return relevantConfig != null;
        }
        return true;
    }

    private FieldScreenRenderLayoutItem getFieldScreenRenderLayoutItem(MutableIssue issue, OrderableField orderableField, FieldScreenRenderer fieldScreenRenderer, boolean useFallback) {
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderer.getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                if (!fieldScreenRenderLayoutItem.isShow((Issue)issue) || !orderableField.equals(fieldScreenRenderLayoutItem.getOrderableField())) continue;
                return fieldScreenRenderLayoutItem;
            }
        }
        if (useFallback) {
            return this.getFieldScreenRenderLayoutItemFallback(orderableField);
        }
        return null;
    }

    private FieldScreenRenderLayoutItem getFieldScreenRenderLayoutItemFallback(OrderableField orderableField) {
        boolean needFieldScreenRenderLayoutItem;
        NotRequiredFieldScreenRenderLayoutItem fieldScreenRenderLayoutItem = null;
        boolean bl = needFieldScreenRenderLayoutItem = !(orderableField instanceof CustomField);
        if (needFieldScreenRenderLayoutItem) {
            fieldScreenRenderLayoutItem = new NotRequiredFieldScreenRenderLayoutItem();
        }
        return fieldScreenRenderLayoutItem;
    }

    private FieldLayoutItem getFieldLayoutItem(MutableIssue issue, OrderableField orderableField, FieldScreenRenderer fieldScreenRenderer) {
        FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem = this.getFieldScreenRenderLayoutItem(issue, orderableField, fieldScreenRenderer, false);
        if (fieldScreenRenderLayoutItem != null) {
            return fieldScreenRenderLayoutItem.getFieldLayoutItem();
        }
        return null;
    }

    I18nHelper getI18n(ApplicationUser user) {
        return this.i18nBeanFactory.getInstance(user);
    }

    Map<String, Object> cloneFieldValuesHolder(IssueInputParameters issueInputParameters) {
        HashMap<String, Object> clonedFieldValuesHolder = new HashMap<String, Object>();
        clonedFieldValuesHolder.putAll(issueInputParameters.getFieldValuesHolder());
        return clonedFieldValuesHolder;
    }

    boolean hasPermissionToEdit(ApplicationUser user, Issue issue, ErrorCollection errors) {
        boolean hasPermission = this.issueManager.isEditable(issue, user);
        if (!hasPermission) {
            I18n2 i18n = this.i18nFactoryService.getI18n(user);
            boolean editbleWorkflow = this.issueManager.isEditable(issue);
            if (!editbleWorkflow) {
                errors.addErrorMessage(i18n.getText("gh.issue.error.edit.not.allowed.workflow"), ErrorCollection.Reason.FORBIDDEN);
            } else {
                errors.addErrorMessage(i18n.getText("gh.issue.error.edit.not.allowed"), ErrorCollection.Reason.FORBIDDEN);
            }
        }
        return hasPermission;
    }

    FieldScreenRenderLayoutItem getFieldScreenRendererLayoutItemForField(ApplicationUser user, Issue issue, OrderableField field) {
        FieldScreenRenderer renderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION);
        return renderer.getFieldScreenRenderLayoutItem(field);
    }

    void updateIssueWithComment(MutableIssue issue, ApplicationUser user, Map<String, Object> fieldValuesHolder) {
        OrderableField commentField = (OrderableField)this.fieldManager.getField(SystemSearchConstants.forComments().getFieldId());
        FieldLayoutItem fieldLayoutItem = this.getFieldScreenRendererLayoutItemForField(user, (Issue)issue, commentField).getFieldLayoutItem();
        commentField.updateIssue(fieldLayoutItem, issue, fieldValuesHolder);
    }

    FieldScreenRenderer getUpdateFieldScreenRenderer(ApplicationUser user, Issue issue) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION);
    }
}

