/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue;

import com.atlassian.greenhopper.manager.issue.issuetypes.EpicIssueTypeProvider;
import com.atlassian.greenhopper.manager.issue.issuetypes.StoryIssueTypeProvider;
import com.atlassian.greenhopper.service.issue.IssueTypePrototype;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.jira.issue.issuetype.IssueType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssueTypeServiceImpl
implements IssueTypeService {
    @Autowired
    private EpicIssueTypeProvider epicIssueTypeProvider;
    @Autowired
    private StoryIssueTypeProvider storyIssueTypeProvider;

    @Override
    public IssueType getOrCreateEpicIssueType() {
        return this.epicIssueTypeProvider.getOrCreateIssueType();
    }

    @Override
    public IssueType getOrCreateStoryIssueType() {
        return this.storyIssueTypeProvider.getOrCreateIssueType();
    }

    @Override
    public boolean hasIssueTypeId(IssueTypePrototype typePrototype) {
        switch (typePrototype) {
            case ALL: {
                return true;
            }
            case EPIC: {
                return this.hasEpicId();
            }
            case STORY: {
                return this.hasStoryId();
            }
        }
        throw new IllegalArgumentException("Unknown type prototype: " + (Object)((Object)typePrototype));
    }

    private boolean hasEpicId() {
        return this.epicIssueTypeProvider.doesIssueTypeExist();
    }

    private boolean hasStoryId() {
        return this.storyIssueTypeProvider.doesIssueTypeExist();
    }

    @Override
    public IssueType getIssueType(IssueTypePrototype typePrototype) {
        switch (typePrototype) {
            case ALL: {
                return null;
            }
            case EPIC: {
                return this.getOrCreateEpicIssueType();
            }
            case STORY: {
                return this.getOrCreateStoryIssueType();
            }
        }
        throw new IllegalArgumentException("Unknown type prototype: " + (Object)((Object)typePrototype));
    }

    @Override
    public String getIssueTypeId(IssueTypePrototype typePrototype) {
        IssueType type = this.getIssueType(typePrototype);
        return type != null ? type.getId() : null;
    }
}

