/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue;

import com.atlassian.greenhopper.issue.IssueTypeSchemeService;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssueTypeSchemeServiceImpl
implements IssueTypeSchemeService {
    @Autowired
    private IssueTypeSchemeManager issueTypeSchemeManager;
    @Autowired
    private IssueTypeService issueTypeService;
    @Autowired
    private OptionSetManager optionSetManager;

    @Override
    public void addAllAgileIssueTypesToScheme(FieldConfigScheme issueTypeScheme) {
        boolean addStory;
        IssueType epic = this.issueTypeService.getOrCreateEpicIssueType();
        IssueType story = this.issueTypeService.getOrCreateStoryIssueType();
        FieldConfig fieldConfig = issueTypeScheme.getOneAndOnlyConfig();
        Collection currentIssueTypeIds = this.optionSetManager.getOptionsForConfig(fieldConfig).getOptionIds();
        boolean addEpic = !currentIssueTypeIds.contains(epic.getId());
        boolean bl = addStory = !currentIssueTypeIds.contains(story.getId());
        if (addEpic || addStory) {
            ArrayList newIssueTypeIds = Lists.newArrayList((Iterable)currentIssueTypeIds);
            if (addEpic) {
                newIssueTypeIds.add(epic.getId());
            }
            if (addStory) {
                newIssueTypeIds.add(story.getId());
            }
            this.issueTypeSchemeManager.update(issueTypeScheme, (Collection)newIssueTypeIds);
        }
    }

    @Override
    public void addEpicIssueTypeToScheme(FieldConfigScheme issueTypeScheme) {
        IssueType epic = this.issueTypeService.getOrCreateEpicIssueType();
        FieldConfig fieldConfig = issueTypeScheme.getOneAndOnlyConfig();
        Collection currentIssueTypeIds = this.optionSetManager.getOptionsForConfig(fieldConfig).getOptionIds();
        ArrayList newIssueTypeIds = Lists.newArrayList((Iterable)currentIssueTypeIds);
        if (!newIssueTypeIds.contains(epic.getId())) {
            newIssueTypeIds.add(epic.getId());
            this.issueTypeSchemeManager.update(issueTypeScheme, (Collection)newIssueTypeIds);
        }
    }
}

