/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueDataCollector;
import com.atlassian.greenhopper.service.issue.IssueDataLoader;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.callback.IssueDataCallback;
import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.issue.search.DocumentWithId;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssueDataServiceImpl
implements IssueDataService {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private SearchProviderFactory searchProviderFactory;
    private SearchProvider searchProvider;
    protected LoggerWrapper performanceLogger = LoggerWrapper.with("com.atlassian.greenhopper.performance");

    @Autowired
    public IssueDataServiceImpl(SearchProviderFactory searchProviderFactory, SearchProvider searchProvider) {
        this.searchProviderFactory = searchProviderFactory;
        this.searchProvider = searchProvider;
    }

    @Override
    @Nonnull
    public <T extends IssueDataCallback> ServiceOutcome<Void> find(ApplicationUser user, Query query, T callback) {
        ErrorCollection errors = this.findImpl(user, query, callback, null, false, false, null);
        return ServiceOutcomeImpl.from(errors);
    }

    @Override
    public <T extends IssueDataCallback> ServiceOutcome<Void> findWithServiceOutcome(ApplicationUser user, Query query, T callback) {
        ErrorCollection errors = this.findImpl(user, query, callback, null, false, false, null);
        return ServiceOutcomeImpl.from(errors);
    }

    @Override
    public <T extends Collector> ServiceOutcome<Void> findWithServiceOutcome(ApplicationUser user, Query query, T collector) {
        ErrorCollection errors = new ErrorCollection();
        try {
            this.searchProvider.search(SearchQuery.create((Query)query, (ApplicationUser)user), collector);
        }
        catch (SearchException e) {
            this.log.exception(e);
            errors.addError("gh.error.lucene.issue", new Object[0]);
        }
        return ServiceOutcomeImpl.from(errors);
    }

    @Override
    public <T extends IssueDataCallback> ServiceOutcome<Void> find(ApplicationUser user, Query query, T callback, org.apache.lucene.search.Query andQuery) {
        ErrorCollection errors = this.findImpl(user, query, callback, null, false, false, andQuery);
        return ServiceOutcomeImpl.from(errors);
    }

    @Override
    @Nonnull
    public <T extends IssueDataCallback> ServiceOutcome<Void> findAndSortWithServiceOutcome(ApplicationUser user, Query query, T callback, PagerFilter<?> pager) {
        ErrorCollection errors = this.findImpl(user, query, callback, pager, false, true, null);
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        return ServiceOutcomeImpl.ok();
    }

    @Override
    @Nonnull
    public <T extends IssueDataCallback> ServiceOutcome<Void> findOverrideSecurity(ApplicationUser user, Query query, T callback) {
        ErrorCollection errors = this.findImpl(user, query, callback, null, true, false, null);
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public <T extends IssueDataCallback> ServiceOutcome<Void> findAndSortOverrideSecurity(ApplicationUser user, Query query, T callback) {
        ErrorCollection errors = this.findImpl(user, query, callback, null, true, true, null);
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        return ServiceOutcomeImpl.ok();
    }

    @Override
    @Nonnull
    public <T extends IssueDataCallback> ServiceOutcome<Void> findAndSort(ApplicationUser user, Query query, T callback) {
        ErrorCollection errors = this.findImpl(user, query, callback, null, false, true, null);
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        return ServiceOutcomeImpl.ok();
    }

    @Override
    @Nonnull
    public ServiceOutcome<Long> count(ApplicationUser user, Query query) {
        try {
            return ServiceOutcomeImpl.ok(this.searchProvider.getHitCount(SearchQuery.create((Query)query, (ApplicationUser)user)));
        }
        catch (SearchException e) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addErrorMessage(e.getMessage());
            return ServiceOutcomeImpl.from((com.atlassian.jira.util.ErrorCollection)errors);
        }
    }

    private <T extends IssueDataCallback> ErrorCollection findImpl(ApplicationUser user, Query query, T callback, PagerFilter<?> pager, boolean overwriteSecurity, boolean sort, org.apache.lucene.search.Query andQuery) {
        if (!sort && pager != null) {
            throw new IllegalStateException("Why would you use a pager without sorting?");
        }
        if (andQuery != null && (overwriteSecurity || pager != null || sort)) {
            throw new IllegalStateException("andQuery not supported with pager, sorting or overrideSecurity.");
        }
        ErrorCollection errors = new ErrorCollection();
        ManagedIndexSearcher searcher = this.searchProviderFactory.getSearcher("issues");
        IssueDataLoader issueDataLoader = new IssueDataLoader((IndexSearcher)searcher, callback);
        IssueDataCollector collector = new IssueDataCollector(issueDataLoader);
        try {
            long a = System.currentTimeMillis();
            ImmutableSet loadEmptyDocuments = ImmutableSet.of();
            if (overwriteSecurity && sort) {
                SearchResults luceneSearchResults = this.searchProvider.search(SearchQuery.create((Query)query, (ApplicationUser)user).overrideSecurity(true), PagerFilter.getUnlimitedFilter(), (Set)loadEmptyDocuments);
                luceneSearchResults.getResults().stream().map(DocumentWithId::getDocId).forEach(issueDataLoader::collect);
                this.perfLog("SearchProvider.searchAndSortOverrideSecurity", a);
            } else if (overwriteSecurity) {
                this.searchProvider.search(SearchQuery.create((Query)query, (ApplicationUser)user).overrideSecurity(true), (Collector)collector);
                this.perfLog("SearchProvider.searchOverrideSecurity", a);
            } else if (pager != null) {
                SearchResults luceneSearchResults = this.searchProvider.search(SearchQuery.create((Query)query, (ApplicationUser)user), pager, (Set)loadEmptyDocuments);
                luceneSearchResults.getResults().stream().map(DocumentWithId::getDocId).forEach(issueDataLoader::collect);
                this.perfLog("SearchProvider.searchAndSort", a);
            } else if (sort) {
                SearchResults luceneSearchResults = this.searchProvider.search(SearchQuery.create((Query)query, (ApplicationUser)user), PagerFilter.getUnlimitedFilter(), (Set)loadEmptyDocuments);
                luceneSearchResults.getResults().stream().map(DocumentWithId::getDocId).forEach(issueDataLoader::collect);
                this.perfLog("SearchProvider.searchAndSort", a);
            } else {
                this.searchProvider.search(SearchQuery.create((Query)query, (ApplicationUser)user).luceneQuery(andQuery), (Collector)collector);
                this.perfLog("SearchProvider.search", a);
            }
        }
        catch (SearchException e) {
            this.log.exception(e);
            errors.addError("gh.error.lucene.issue", new Object[0]);
        }
        return errors;
    }

    private void perfLog(String message, long start) {
        if (!this.performanceLogger.isDebugEnabled()) {
            return;
        }
        try {
            this.performanceLogger.debug(message + "  %dms", System.currentTimeMillis() - start);
        }
        catch (RuntimeException e) {
            this.performanceLogger.error("Unable to format message: " + message, new Object[0]);
            this.performanceLogger.exception(e);
        }
    }
}

