/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue;

import com.atlassian.greenhopper.service.issue.callback.IssueDataCallback;
import com.atlassian.greenhopper.util.NumberUtils;
import com.atlassian.greenhopper.util.lucene.LimitedStoredFieldVisitor;
import com.atlassian.jira.util.RuntimeIOException;
import io.atlassian.fugue.Option;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.IndexSearcher;

class IssueDataLoader {
    private final IndexSearcher searcher;
    private final IssueDataCallback callback;

    public IssueDataLoader(IndexSearcher searcher, IssueDataCallback callback) {
        this.searcher = searcher;
        this.callback = callback;
    }

    public void collect(int docId) {
        try {
            Document d;
            if (this.callback.requiresIssueDoc()) {
                d = this.searcher.doc(docId);
            } else {
                LimitedStoredFieldVisitor fieldVisitor = new LimitedStoredFieldVisitor(this.callback.getFields());
                this.searcher.doc(docId, (StoredFieldVisitor)fieldVisitor);
                d = fieldVisitor.getDocument();
            }
            this.collect(d);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void collect(Document d) {
        Option issueDoc = this.callback.requiresIssueDoc() ? Option.option((Object)d) : Option.none();
        Long issueId = NumberUtils.toLong(d.get("issue_id"));
        String issueKey = d.get("key");
        for (String fieldName : this.callback.getFields()) {
            String[] values = d.getValues(fieldName);
            if (values.length > 0) {
                for (String value : values) {
                    this.callback.fieldData(issueId, issueKey, fieldName, value);
                }
                continue;
            }
            this.callback.fieldData(issueId, issueKey, fieldName, null);
        }
        this.callback.issueComplete(issueId, issueKey, (Option<Document>)issueDoc);
    }
}

