/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue;

import com.atlassian.greenhopper.customfield.epiclink.EpicLinkCustomFieldIndexer;
import com.atlassian.greenhopper.model.query.ClauseToAdd;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.EpicHistoryDataCollector;
import com.atlassian.greenhopper.service.issue.EpicHistoryResult;
import com.atlassian.greenhopper.service.issue.EpicHistoryService;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.callback.AbstractCompoundDataCallback;
import com.atlassian.greenhopper.service.issue.callback.ComposedIssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.EstimatableIssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueDataCallback;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import io.atlassian.fugue.Option;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EpicHistoryServiceImpl
implements EpicHistoryService {
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    @Autowired
    private IssueDataService issueDataService;
    @Autowired
    private EstimateStatisticService estimateStatisticService;

    @Override
    public ServiceOutcome<EpicHistoryResult> findEpicHistory(@Nonnull ApplicationUser user, @Nonnull RapidView rapidView, @Nonnull Issue epic, @Nonnull StatisticsField statisticsField) {
        return this.findEpicHistory(user, rapidView, epic, statisticsField, ClauseToAdd.noClauseToAdd());
    }

    @Override
    public ServiceOutcome<EpicHistoryResult> findEpicHistory(@Nonnull ApplicationUser user, @Nonnull RapidView rapidView, @Nonnull Issue epic, @Nonnull StatisticsField statisticsField, @Nonnull ClauseToAdd additionalClause) {
        ServiceOutcome<Query> query = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        if (!query.isValid()) {
            return ServiceOutcomeImpl.error(query);
        }
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)query.getValue());
        additionalClause.appendWithDefaultAnd(queryBuilder);
        CustomField epicLinkField = this.epicCustomFieldService.getDefaultEpicLinkField();
        EpicHistoryDataCollector collector = new EpicHistoryDataCollector(epicLinkField, epic);
        Option maybeAllIssueSet = Option.none();
        EstimatableIssueDataCallback estimatableIssueDataCallback = new EstimatableIssueDataCallback(this.estimateStatisticService, statisticsField, (Option<Set<String>>)maybeAllIssueSet);
        ComposedIssueDataCallback composedIssueDataCallback = ComposedIssueDataCallback.of((IssueDataCallback[])new AbstractCompoundDataCallback[]{collector, estimatableIssueDataCallback});
        ServiceOutcome<Void> collectOutcome = this.findHistoryForEpic(user, queryBuilder.buildQuery(), epic, composedIssueDataCallback, epicLinkField);
        if (!collectOutcome.isValid()) {
            return ServiceOutcomeImpl.error(collectOutcome);
        }
        return ServiceOutcomeImpl.ok(new EpicHistoryResult(collector.getIssueEpicHistory(), estimatableIssueDataCallback.getEstimatableIssueKeys()));
    }

    private ServiceOutcome<Void> findHistoryForEpic(ApplicationUser user, Query query, Issue epic, IssueDataCallback collector, CustomField epicLinkField) {
        Term term = new Term(EpicLinkCustomFieldIndexer.getHistoryFieldId(epicLinkField), epic.getId().toString());
        TermQuery historyEpicTerm = new TermQuery(term);
        return this.issueDataService.find(user, query, collector, (org.apache.lucene.search.Query)historyEpicTerm);
    }
}

