/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue;

import com.atlassian.greenhopper.customfield.epiclink.EpicLinkCustomFieldIndexer;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkHistoryEntry;
import com.atlassian.greenhopper.service.issue.callback.AbstractCompoundDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueFieldValueProvider;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EpicHistoryDataCollector
extends AbstractCompoundDataCallback {
    private final CustomField epicLinkField;
    private String valuePrefix;
    private Map<String, List<EpicLinkHistoryEntry>> issueEpicHistory;

    public EpicHistoryDataCollector(CustomField epicLinkField, Issue epic) {
        this.epicLinkField = epicLinkField;
        this.valuePrefix = EpicLinkHistoryEntry.getLuceneValuePrefix(epic.getId());
        this.issueEpicHistory = new HashMap<String, List<EpicLinkHistoryEntry>>();
    }

    @Override
    public Set<String> getFields() {
        return Collections.singleton(EpicLinkCustomFieldIndexer.getChangesFieldId(this.epicLinkField));
    }

    @Override
    protected void fieldData(Long issueId, String issueKey, IssueFieldValueProvider issueFieldValueProvider) {
        ArrayList<EpicLinkHistoryEntry> tempEntries = new ArrayList<EpicLinkHistoryEntry>();
        for (String data : issueFieldValueProvider.getList(EpicLinkCustomFieldIndexer.getChangesFieldId(this.epicLinkField))) {
            EpicLinkHistoryEntry entry;
            if (data == null || !data.startsWith(this.valuePrefix) || (entry = EpicLinkHistoryEntry.fromLuceneValue(data)) == null) continue;
            tempEntries.add(entry);
        }
        this.issueEpicHistory.put(issueKey, tempEntries);
    }

    public Map<String, List<EpicLinkHistoryEntry>> getIssueEpicHistory() {
        return this.issueEpicHistory;
    }
}

