/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issue;

import com.atlassian.event.api.EventListener;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;

public abstract class AbstractIssueEventListener {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());

    @EventListener
    public void onIssueEvent(IssueEvent event) {
        try {
            Long typeId = event.getEventTypeId();
            Issue issue = event.getIssue();
            this.log.debug("listener %s recieved issue event type %d for issue %s", this.getClass().getName(), typeId, issue != null ? issue.getKey() : "null");
            this.doOnIssueEvent(typeId, issue, event);
        }
        catch (Throwable t) {
            this.log.exception(t);
        }
    }

    protected abstract void doOnIssueEvent(Long var1, Issue var2, IssueEvent var3);
}

