/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.index;

import com.atlassian.event.api.EventListener;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.customfield.sprint.SprintCustomFieldIndexer;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.index.IndexCheckService;
import com.atlassian.greenhopper.service.issue.SearchService;
import com.atlassian.greenhopper.service.properties.PropertyDao;
import com.atlassian.greenhopper.service.rank.SortedByRankFieldResult;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.ReindexAllCancelledEvent;
import com.atlassian.jira.issue.index.ReindexAllCompletedEvent;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IndexCheckServiceImpl
implements IndexCheckService {
    private static final String KEY_SPRINT_INDEX_CHECK_NECESSARY = "GreenHopper.Sprint.Index.Check.Necessary";
    private static final String KEY_RANK_INDEX_CHECK_NECESSARY = "GreenHopper.Rank.Index.Check.Necessary";
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    private SprintCustomFieldService sprintCustomFieldService;
    @Autowired
    private LexoRankCustomFieldService lexoRankCustomFieldService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private PropertyDao propertyDao;
    @Autowired
    private TaskManager taskManager;

    @Override
    @Nonnull
    public IndexCheckService.CheckResult<Boolean> validateCheck(@Nonnull IndexCheckService.CheckSpec checkSpec) {
        IndexCheckService.CheckResult<Boolean> result = new IndexCheckService.CheckResult<Boolean>();
        for (IndexCheckService.CheckType checkType : checkSpec.getCheckTypes()) {
            IndexChecker indexChecker = this.resolveChecker(checkType);
            ServiceOutcome<Boolean> checkOutcome = ServiceOutcomeImpl.ok(indexChecker.isCheckNecessary(checkSpec));
            result.addResult(checkType, checkOutcome);
        }
        return result;
    }

    @Override
    @Nonnull
    public IndexCheckService.CheckResult<Void> performCheck(@Nonnull IndexCheckService.CheckSpec checkSpec) {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        IndexCheckService.CheckResult<Void> result = new IndexCheckService.CheckResult<Void>();
        for (IndexCheckService.CheckType checkType : checkSpec.getCheckTypes()) {
            IndexChecker indexChecker = this.resolveChecker(checkType);
            ServiceOutcome<Object> checkOutcome = ServiceOutcomeImpl.ok();
            if (indexChecker.isCheckNecessary(checkSpec)) {
                checkOutcome = this.performCheck(user, checkSpec, indexChecker);
            }
            result.addResult(checkType, checkOutcome);
        }
        return result;
    }

    @Override
    public void setCheckNecessary(@Nonnull IndexCheckService.CheckType checkType, @Nonnull Option<String> flag) {
        IndexChecker indexChecker = this.resolveChecker(checkType);
        String key = indexChecker.getIndexCheckKey();
        this.propertyDao.setStringProperty(key, (String)flag.getOrElse((Object)"true"));
    }

    @Override
    @EventListener
    public void onReindexAllCompleted(ReindexAllCompletedEvent event) {
        for (IndexCheckService.CheckType checkType : IndexCheckService.CheckType.values()) {
            IndexChecker indexChecker = this.resolveChecker(checkType);
            this.deleteFlag(indexChecker.getIndexCheckKey());
        }
    }

    @Override
    @EventListener
    public void onReindexAllCancelled(ReindexAllCancelledEvent event) {
        for (IndexCheckService.CheckType checkType : IndexCheckService.CheckType.values()) {
            IndexChecker indexChecker = this.resolveChecker(checkType);
            String flag = this.getFlag(indexChecker.getIndexCheckKey());
            if (flag == null || "false".equalsIgnoreCase(flag)) continue;
            this.setCheckNecessary(checkType, (Option<String>)Option.some((Object)"true"));
        }
    }

    private IndexChecker resolveChecker(IndexCheckService.CheckType checkType) {
        switch (checkType) {
            case SPRINT: {
                return new SprintIndexChecker();
            }
            case RANK: {
                return new RankIndexChecker();
            }
        }
        throw new IllegalStateException();
    }

    private ServiceOutcome<Void> performCheck(ApplicationUser user, IndexCheckService.CheckSpec checkSpec, IndexChecker indexChecker) {
        ServiceOutcome<Query> baseQuery = this.buildBaselineQuery(user, checkSpec);
        if (baseQuery.isInvalid()) {
            return ServiceOutcomeImpl.error(baseQuery);
        }
        ServiceOutcome<org.apache.lucene.search.Query> specificQuery = indexChecker.buildSpecificQuery(user, baseQuery.getValue(), checkSpec);
        if (specificQuery.isInvalid()) {
            return ServiceOutcomeImpl.error(specificQuery);
        }
        ServiceOutcome<Long> baseOutcome = this.searchService.searchCountOverrideSecurity(user, baseQuery.getValue());
        ServiceOutcome<Long> specificOutcome = this.searchService.searchCountOverrideSecurity(user, specificQuery.getValue());
        if (baseOutcome.isInvalid() || specificOutcome.isInvalid()) {
            return baseOutcome.isInvalid() ? ServiceOutcomeImpl.error(baseOutcome) : ServiceOutcomeImpl.error(specificOutcome);
        }
        ServiceOutcome<Void> comparison = indexChecker.compare(baseOutcome.getValue(), specificOutcome.getValue());
        if (comparison.isValid() && !checkSpec.isViewSpecific()) {
            this.deleteFlag(indexChecker.getIndexCheckKey());
        }
        return comparison;
    }

    private Query buildEmptyQuery() {
        return JqlQueryBuilder.newBuilder().buildQuery();
    }

    private boolean areEnoughIssuesCorrectlyIndexed(long issueCountInIndex, long properlyIndexedIssueCount) {
        long ninetyPercent = (long)((double)issueCountInIndex * 0.9);
        return ninetyPercent <= properlyIndexedIssueCount;
    }

    private ServiceOutcome<Query> buildBaselineQuery(ApplicationUser user, IndexCheckService.CheckSpec checkSpec) {
        if (!checkSpec.isViewSpecific()) {
            return ServiceOutcomeImpl.ok(this.buildEmptyQuery());
        }
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder();
        for (RapidView rapidView : checkSpec.getRapidViews()) {
            ServiceOutcome<Query> outcome = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
            if (outcome.isInvalid()) {
                return outcome;
            }
            if (outcome.getValue() == null || outcome.getValue().getWhereClause() == null) {
                return outcome;
            }
            jqlQueryBuilder.where().defaultOr().sub().addClause(outcome.getValue().getWhereClause()).endsub();
        }
        return ServiceOutcomeImpl.ok(jqlQueryBuilder.buildQuery());
    }

    private String getFlag(String key) {
        Object value = this.propertyDao.getPropertyAsType(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "true" : null;
        }
        return null;
    }

    private void deleteFlag(String key) {
        this.propertyDao.deleteProperty(key);
    }

    private class RankIndexChecker
    implements IndexChecker {
        private RankIndexChecker() {
        }

        @Override
        public String getIndexCheckKey() {
            return IndexCheckServiceImpl.KEY_RANK_INDEX_CHECK_NECESSARY;
        }

        @Override
        public boolean isCheckNecessary(IndexCheckService.CheckSpec checkSpec) {
            String flag = IndexCheckServiceImpl.this.getFlag(this.getIndexCheckKey());
            if (flag == null || "false".equalsIgnoreCase(flag)) {
                return false;
            }
            if ("true".equalsIgnoreCase(flag)) {
                return true;
            }
            Long taskId = Long.parseLong(flag);
            TaskDescriptor task = IndexCheckServiceImpl.this.taskManager.getTask(taskId);
            if (task == null || task.isFinished()) {
                IndexCheckServiceImpl.this.deleteFlag(this.getIndexCheckKey());
                return false;
            }
            return true;
        }

        @Override
        public ServiceOutcome<org.apache.lucene.search.Query> buildSpecificQuery(ApplicationUser user, Query baseQuery, IndexCheckService.CheckSpec checkSpec) {
            return IndexCheckServiceImpl.this.searchService.buildLuceneQuery((QueryCreationContext)new QueryCreationContextImpl(user, true), baseQuery, (Option<org.apache.lucene.search.Query>)Option.some((Object)this.buildRankQuery(user, checkSpec)));
        }

        @Override
        public ServiceOutcome<Void> compare(Long baseCount, Long specificCount) {
            if (IndexCheckServiceImpl.this.areEnoughIssuesCorrectlyIndexed(baseCount, specificCount)) {
                return ServiceOutcomeImpl.ok();
            }
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.error.greenhopper.ranking.index.unavailable", new Object[0]);
        }

        private org.apache.lucene.search.Query buildRankQuery(ApplicationUser user, IndexCheckService.CheckSpec checkSpec) {
            ServiceOutcome<SortedByRankFieldResult> sortedByRankField;
            ServiceOutcome<Query> rapidViewQuery;
            CustomField lexoRankField = null;
            if (checkSpec.isViewSpecific() && (rapidViewQuery = IndexCheckServiceImpl.this.rapidViewQueryService.getRapidViewQuery(user, checkSpec.getRapidViews().iterator().next())).isValid() && (sortedByRankField = IndexCheckServiceImpl.this.lexoRankCustomFieldService.getSortedByRankField(rapidViewQuery.getValue())).isValid()) {
                lexoRankField = sortedByRankField.getValue().getCustomField();
            }
            if (lexoRankField == null) {
                lexoRankField = IndexCheckServiceImpl.this.lexoRankCustomFieldService.getDefaultRankField();
            }
            TermQuery query = new TermQuery(new Term("nonemptyfieldids", lexoRankField.getId()));
            return query;
        }
    }

    private class SprintIndexChecker
    implements IndexChecker {
        private SprintIndexChecker() {
        }

        @Override
        public String getIndexCheckKey() {
            return IndexCheckServiceImpl.KEY_SPRINT_INDEX_CHECK_NECESSARY;
        }

        @Override
        public boolean isCheckNecessary(IndexCheckService.CheckSpec checkSpec) {
            boolean result = false;
            if (checkSpec.isViewSpecific()) {
                for (RapidView rapidView : checkSpec.getRapidViews()) {
                    result = result || rapidView.isSprintSupportEnabled();
                }
            }
            return result && "true".equalsIgnoreCase(IndexCheckServiceImpl.this.getFlag(this.getIndexCheckKey()));
        }

        @Override
        public ServiceOutcome<org.apache.lucene.search.Query> buildSpecificQuery(ApplicationUser user, Query baseQuery, IndexCheckService.CheckSpec checkSpec) {
            return IndexCheckServiceImpl.this.searchService.buildLuceneQuery((QueryCreationContext)new QueryCreationContextImpl(user, true), baseQuery, (Option<org.apache.lucene.search.Query>)Option.some((Object)this.buildSprintQuery()));
        }

        @Override
        public ServiceOutcome<Void> compare(Long baseCount, Long specificCount) {
            if (IndexCheckServiceImpl.this.areEnoughIssuesCorrectlyIndexed(baseCount, specificCount)) {
                return ServiceOutcomeImpl.ok();
            }
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.error.greenhopper.scrum.unavailable", new Object[0]);
        }

        private org.apache.lucene.search.Query buildSprintQuery() {
            CustomField sprintField = IndexCheckServiceImpl.this.sprintCustomFieldService.getDefaultSprintField();
            String historicSprintsDocumentId = SprintCustomFieldIndexer.getHistoryFieldId(sprintField);
            TermQuery query = new TermQuery(new Term("nonemptyfieldids", historicSprintsDocumentId));
            return query;
        }
    }

    private static interface IndexChecker {
        public String getIndexCheckKey();

        public boolean isCheckNecessary(IndexCheckService.CheckSpec var1);

        public ServiceOutcome<org.apache.lucene.search.Query> buildSpecificQuery(ApplicationUser var1, Query var2, IndexCheckService.CheckSpec var3);

        public ServiceOutcome<Void> compare(Long var1, Long var2);
    }
}

