/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.index;

import com.atlassian.event.api.EventListener;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.jira.issue.index.ReindexAllCancelledEvent;
import com.atlassian.jira.issue.index.ReindexAllCompletedEvent;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public interface IndexCheckService {
    @Nonnull
    public CheckResult<Boolean> validateCheck(@Nonnull CheckSpec var1);

    @Nonnull
    public CheckResult<Void> performCheck(@Nonnull CheckSpec var1);

    public void setCheckNecessary(@Nonnull CheckType var1, @Nonnull Option<String> var2);

    @EventListener
    public void onReindexAllCompleted(ReindexAllCompletedEvent var1);

    @EventListener
    public void onReindexAllCancelled(ReindexAllCancelledEvent var1);

    public static class CheckResult<T> {
        private final Map<CheckType, ServiceOutcome<T>> results = Maps.newHashMap();

        public CheckResult addResult(CheckType checkType, ServiceOutcome<T> outcome) {
            this.results.put(checkType, outcome);
            return this;
        }

        public ServiceOutcome<T> getOutcome(CheckType checkType) {
            return this.results.containsKey((Object)checkType) ? this.results.get((Object)checkType) : ServiceOutcomeImpl.ok();
        }

        public Map<CheckType, ServiceOutcome<T>> getResults() {
            return this.results;
        }

        public boolean isValid() {
            return !this.isInvalid();
        }

        public boolean isInvalid() {
            for (ServiceOutcome<T> outcome : this.results.values()) {
                if (!outcome.isInvalid()) continue;
                return true;
            }
            return false;
        }
    }

    public static class CheckSpec {
        private final Set<CheckType> checkTypes = Sets.newHashSet();
        private final Set<RapidView> rapidViews = Sets.newHashSet();

        public Set<CheckType> getCheckTypes() {
            return this.checkTypes;
        }

        public Set<RapidView> getRapidViews() {
            return this.rapidViews;
        }

        public boolean isViewSpecific() {
            return !this.rapidViews.isEmpty();
        }

        public CheckSpec addAllCheckTypes() {
            this.checkTypes.addAll(Arrays.asList(CheckType.values()));
            return this;
        }

        public CheckSpec addCheckTypes(CheckType ... checkTypes) {
            return this.addCheckTypes(Arrays.asList(checkTypes));
        }

        public CheckSpec addCheckTypes(Collection<CheckType> checkTypes) {
            this.checkTypes.addAll(checkTypes);
            return this;
        }

        public CheckSpec addRapidViews(RapidView ... rapidViews) {
            this.rapidViews.addAll(Arrays.asList(rapidViews));
            return this;
        }
    }

    public static enum CheckType {
        SPRINT,
        RANK;

    }
}

