/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.configuration;

import com.atlassian.greenhopper.features.JiraSoftwareFeature;
import com.atlassian.greenhopper.service.configuration.JiraSoftwareFeatureService;
import com.atlassian.greenhopper.service.properties.PropertyDao;
import com.google.common.annotations.VisibleForTesting;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JiraSoftwareFeatureServiceImpl
implements JiraSoftwareFeatureService {
    private static final String OLD_PS_PROPERTY_KEY = "GreenHopper.LabsFeature.gh.configuration.parallel.sprints";
    private static final Logger log = Logger.getLogger(JiraSoftwareFeatureServiceImpl.class.getName());
    @Autowired
    private PropertyDao propertyDao;

    @Override
    public void setFeatureEnabled(@Nonnull JiraSoftwareFeature feature, boolean newValue) {
        this.propertyDao.setBooleanProperty(feature.getKey(), newValue);
    }

    @Override
    public boolean isFeatureEnabled(@Nonnull JiraSoftwareFeature feature) {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)this.propertyDao.getBooleanProperty(feature.getKey()), (boolean)feature.isEnabledByDefault());
    }

    @PostConstruct
    @VisibleForTesting
    void runMigration() {
        this.runParallelSprintsMigration();
    }

    private void runParallelSprintsMigration() {
        log.info("Running migration of parallel sprints flag");
        boolean oldValue = Boolean.TRUE.equals(this.propertyDao.getBooleanProperty(OLD_PS_PROPERTY_KEY));
        if (oldValue) {
            this.setFeatureEnabled(JiraSoftwareFeature.PARALLEL_SPRINTS, true);
        }
        this.propertyDao.deleteProperty(OLD_PS_PROPERTY_KEY);
    }
}

