/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.charts;

import com.atlassian.greenhopper.model.charts.WorkRateData;
import com.atlassian.greenhopper.model.charts.WorkRateEntry;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.WorkingDaysConfig;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.charts.WorkRateService;
import com.atlassian.greenhopper.service.rapid.view.workingdays.WorkingDaysService;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkRateServiceImpl
implements WorkRateService {
    @Autowired
    WorkingDaysService workingDaysService;
    @Autowired
    TimeZoneManager timeZoneManager;

    @Override
    @Nonnull
    public ServiceOutcome<WorkRateData> getRateData(@Nullable ApplicationUser user, @Nonnull RapidView rapidView, @Nonnull DateTime start, @Nonnull DateTime end) {
        if (start.isAfter((ReadableInstant)end)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "start must be before end", new Object[0]);
        }
        ServiceOutcome<WorkingDaysConfig> workingDaysConfig = this.workingDaysService.getWorkingDaysConfiguration(user, rapidView);
        if (!workingDaysConfig.isValid()) {
            return ServiceOutcomeImpl.error(workingDaysConfig);
        }
        Set<LocalDate> daysOff = workingDaysConfig.getValue().getNonWorkingLocalDates();
        DateTimeZone dateTimeZone = this.workingDaysService.getDateTimeZone(workingDaysConfig.getValue());
        return this.getWorkRateData(dateTimeZone, workingDaysConfig.getValue(), daysOff, start.getMillis(), end.getMillis());
    }

    ServiceOutcome<WorkRateData> getWorkRateData(DateTimeZone dateTimeZone, WorkingDaysConfig workingDaysConfig, Set<LocalDate> daysOff, long startMillis, long endMillis) {
        boolean[] weekDays = this.getWeekdaysLookupArray(workingDaysConfig);
        HashSet<DateMidnight> additionalOffDays = new HashSet<DateMidnight>();
        for (LocalDate localDate : daysOff) {
            additionalOffDays.add(localDate.toDateMidnight(dateTimeZone));
        }
        DateTime startDate = new DateTime(startMillis, dateTimeZone);
        DateTime endDate = new DateTime(endMillis, dateTimeZone);
        DateTime currentRateStart = startDate;
        DateMidnight currentDay = startDate.toDateMidnight();
        boolean isOff = this.isOffDay(weekDays, additionalOffDays, currentDay);
        ArrayList<WorkRateEntry> rates = new ArrayList<WorkRateEntry>();
        while (currentDay.isBefore((ReadableInstant)endDate)) {
            DateMidnight nextDay = currentDay.plusDays(1);
            boolean isTomorrowOff = this.isOffDay(weekDays, additionalOffDays, nextDay);
            if (isOff != isTomorrowOff) {
                DateTime rateEntryEnd = nextDay.toDateTime();
                if (rateEntryEnd.isAfter((ReadableInstant)endDate)) {
                    rateEntryEnd = endDate;
                }
                this.addEntry(rates, currentRateStart, rateEntryEnd, isOff);
                currentRateStart = rateEntryEnd;
                isOff = isTomorrowOff;
            }
            currentDay = nextDay;
        }
        if (currentRateStart.isBefore((ReadableInstant)endDate)) {
            this.addEntry(rates, currentRateStart, endDate, isOff);
        }
        WorkRateData data = new WorkRateData();
        data.setDateTimeZone(dateTimeZone);
        data.setRates(rates);
        return ServiceOutcomeImpl.ok(data);
    }

    private void addEntry(List<WorkRateEntry> rates, DateTime startMillis, DateTime endMillis, boolean isOff) {
        WorkRateEntry entry = new WorkRateEntry(startMillis, endMillis, isOff);
        rates.add(entry);
    }

    private boolean isOffDay(boolean[] weekDays, Set<DateMidnight> additionalOffDays, DateMidnight date) {
        boolean isWeekDayOff = !weekDays[date.getDayOfWeek()];
        return isWeekDayOff || additionalOffDays.contains(date);
    }

    private boolean[] getWeekdaysLookupArray(WorkingDaysConfig workingDaysConfig) {
        boolean[] weekdays = new boolean[]{false, workingDaysConfig.isMonday(), workingDaysConfig.isTuesday(), workingDaysConfig.isWednesday(), workingDaysConfig.isThursday(), workingDaysConfig.isFriday(), workingDaysConfig.isSaturday(), workingDaysConfig.isSunday()};
        return weekdays;
    }
}

