/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.charts;

import com.atlassian.greenhopper.jira.JIRAResource;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.charts.ChangeHistoryCallback;
import com.atlassian.greenhopper.service.charts.FixVersionHistoryServiceImpl;
import com.atlassian.greenhopper.service.charts.IssueStatusHistoryCallback;
import com.atlassian.greenhopper.service.charts.IssueStatusHistoryService;
import com.atlassian.greenhopper.service.lucene.ChangeHistorySearchHelper;
import com.atlassian.greenhopper.web.rapid.chart.ChangeHistoryCollector;
import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionsFilterGenerator;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.query.LuceneQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.BitSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TermQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class IssueStatusHistoryServiceImpl
implements IssueStatusHistoryService {
    private static final Logger log = Logger.getLogger(FixVersionHistoryServiceImpl.class);
    private static final String STATUS_FROM = "status.ch_oldvalue";
    private static final String STATUS_TO = "status.ch_newvalue";
    private static final ImmutableSet<String> FIELDS = ImmutableSet.of((Object)"issue_id", (Object)"key", (Object)"ch_date");
    @Autowired
    private IssueIndexManager issueIndexManager;
    @JIRAResource
    private LuceneQueryBuilder luceneQueryBuilder;
    @JIRAResource
    private PermissionsFilterGenerator permissionsFilterGenerator;
    @Autowired
    private ChangeHistorySearchHelper changeHistorySearchHelper;

    @Override
    public ServiceOutcome<Void> collectStatusHistory(ApplicationUser user, Query query, IssueStatusHistoryCallback callback) {
        ErrorCollection errors = new ErrorCollection();
        ManagedIndexSearcher changeHistorySearcher = this.issueIndexManager.getChangeHistorySearcher();
        try {
            BitSet docIds = this.changeHistorySearchHelper.findChangeLogFilter(user, query);
            log.trace((Object)String.format("History index document IDs from join with user query: %s", docIds));
            for (Status status : callback.getStatuses()) {
                log.debug((Object)String.format("Executing query for changes from %s", status.getName()));
                callback.before(status);
                this.executeSearch(callback, (IndexSearcher)changeHistorySearcher, docIds, status, true);
                log.debug((Object)String.format("Executing query for changes to %s", status.getName()));
                this.executeSearch(callback, (IndexSearcher)changeHistorySearcher, docIds, status, false);
                callback.after(status);
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            errors.addError("gh.rapid.chart.status.history.lucene.error", new Object[0]);
        }
        catch (SearchException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            errors.addError("gh.rapid.chart.status.history.lucene.error", new Object[0]);
        }
        return ServiceOutcomeImpl.from(errors);
    }

    private void executeSearch(ChangeHistoryCallback callback, IndexSearcher changeHistorySearcher, BitSet docIdFilter, Status status, Boolean changedFrom) throws IOException {
        ChangeHistoryCollector<Status> collector = new ChangeHistoryCollector<Status>(changeHistorySearcher, callback, docIdFilter, changedFrom, status, (Set<String>)FIELDS);
        BooleanQuery statusChangeQuery = this.buildHistoryQuery(status.getId(), changedFrom);
        log.trace((Object)String.format("Change history query for status %s: [%s]", status.getId(), statusChangeQuery));
        changeHistorySearcher.search((org.apache.lucene.search.Query)statusChangeQuery, collector);
    }

    private BooleanQuery buildHistoryQuery(String value, boolean changedFrom) {
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        String protocolEncoded = "ch-" + (value == null ? "" : value.toLowerCase());
        Term term = new Term(this.getSearchTerm(changedFrom), protocolEncoded);
        query.add((org.apache.lucene.search.Query)new TermQuery(term), BooleanClause.Occur.MUST);
        return query.build();
    }

    private String getSearchTerm(boolean changedFrom) {
        if (changedFrom) {
            return STATUS_FROM;
        }
        return STATUS_TO;
    }
}

