/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.charts;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.charts.ChangeHistoryCallback;
import com.atlassian.greenhopper.service.charts.FixVersionHistoryCallback;
import com.atlassian.greenhopper.service.charts.FixVersionHistoryService;
import com.atlassian.greenhopper.service.lucene.ChangeHistorySearchHelper;
import com.atlassian.greenhopper.web.rapid.chart.ChangeHistoryCollector;
import com.atlassian.greenhopper.web.rapid.chart.FixVersionChangeEntry;
import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TermQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FixVersionHistoryServiceImpl
implements FixVersionHistoryService {
    private static final Logger log = Logger.getLogger(FixVersionHistoryServiceImpl.class);
    private static final String FIX_VERSION_FROM = "fixversion.ch_oldvalue";
    private static final String FIX_VERSION_TO = "fixversion.ch_newvalue";
    private static final Set<String> FIELDS = ImmutableSet.of((Object)"issue_id", (Object)"key", (Object)"ch_date");
    @Autowired
    private IssueIndexManager issueIndexManager;
    @Autowired
    private ChangeHistorySearchHelper changeHistorySearchHelper;

    @Override
    @Nonnull
    public ServiceOutcome<Map<String, List<FixVersionChangeEntry>>> findVersionHistory(@Nonnull ApplicationUser user, @Nonnull Query query, @Nonnull Long versionId) {
        ManagedIndexSearcher changeHistorySearcher = this.issueIndexManager.getChangeHistorySearcher();
        FixVersionHistoryCallback callback = new FixVersionHistoryCallback();
        try {
            BitSet docIds = this.changeHistorySearchHelper.findChangeLogFilter(user, query);
            log.trace((Object)String.format("History index document IDs from join with user query: %s", docIds));
            log.debug((Object)String.format("Executing query for changes from %s", versionId));
            this.executeSearch(callback, (IndexSearcher)changeHistorySearcher, docIds, versionId, true);
            log.debug((Object)String.format("Executing query for changes to %s", versionId));
            this.executeSearch(callback, (IndexSearcher)changeHistorySearcher, docIds, versionId, false);
        }
        catch (IOException e) {
            log.error((Object)e);
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, e.getMessage(), new Object[0]);
        }
        catch (SearchException e) {
            log.error((Object)e);
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, e.getMessage(), new Object[0]);
        }
        return ServiceOutcomeImpl.ok(callback.getChanges());
    }

    private void executeSearch(ChangeHistoryCallback callback, IndexSearcher changeHistorySearcher, BitSet docIdFilter, Long versionId, boolean changedFrom) throws IOException {
        ChangeHistoryCollector<Long> collector = new ChangeHistoryCollector<Long>(changeHistorySearcher, callback, docIdFilter, changedFrom, versionId, FIELDS);
        BooleanQuery fixVersionQuery = this.buildHistoryQuery(String.valueOf(versionId), changedFrom);
        log.trace((Object)String.format("Change history query for status %s: [%s]", versionId, fixVersionQuery));
        changeHistorySearcher.search((org.apache.lucene.search.Query)fixVersionQuery, collector);
    }

    private BooleanQuery buildHistoryQuery(String value, Boolean changedFrom) {
        String searchTerm = this.getSearchTerm(changedFrom);
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        String protocolEncoded = "ch-" + (value == null ? "" : value.toLowerCase());
        Term term = new Term(searchTerm, protocolEncoded);
        query.add((org.apache.lucene.search.Query)new TermQuery(term), BooleanClause.Occur.MUST);
        return query.build();
    }

    private String getSearchTerm(Boolean changedFrom) {
        if (changedFrom.booleanValue()) {
            return FIX_VERSION_FROM;
        }
        return FIX_VERSION_TO;
    }
}

