/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.charts;

import com.atlassian.greenhopper.service.charts.ChangeHistoryCallback;
import com.atlassian.greenhopper.web.rapid.chart.FixVersionChangeEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class FixVersionHistoryCallback
implements ChangeHistoryCallback<Long> {
    private Map<String, List<FixVersionChangeEntry>> changes = new HashMap<String, List<FixVersionChangeEntry>>();

    @Override
    public void changedTo(Long issueId, String issueKey, DateTime changeTime, Long value) {
        List<FixVersionChangeEntry> changesList = this.getChangesList(issueKey);
        changesList.add(this.createChangeEntry(issueId, issueKey, changeTime, value, true));
    }

    @Override
    public void changedFrom(Long issueId, String issueKey, DateTime changeTime, Long value) {
        List<FixVersionChangeEntry> changesList = this.getChangesList(issueKey);
        changesList.add(this.createChangeEntry(issueId, issueKey, changeTime, value, false));
    }

    private FixVersionChangeEntry createChangeEntry(Long issueId, String issueKey, DateTime changeTime, Long value, boolean added) {
        FixVersionChangeEntry changeEntry = new FixVersionChangeEntry();
        changeEntry.added = added;
        changeEntry.date = changeTime;
        changeEntry.versionId = value;
        changeEntry.key = issueKey;
        changeEntry.id = issueId;
        return changeEntry;
    }

    private List<FixVersionChangeEntry> getChangesList(String issueKey) {
        if (!this.changes.containsKey(issueKey)) {
            this.changes.put(issueKey, new ArrayList());
        }
        return this.changes.get(issueKey);
    }

    @Override
    public void before(Long versionId) {
    }

    @Override
    public void after(Long versionId) {
    }

    public Map<String, List<FixVersionChangeEntry>> getChanges() {
        if (this.changes == null) {
            return Collections.emptyMap();
        }
        return this.changes;
    }
}

