/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.api.remote;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheSettingsBuilder;
import com.atlassian.greenhopper.cache.CacheFactoryManager;
import com.atlassian.greenhopper.manager.GreenHopperCache;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.api.remote.RemoteLinkConversationService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteLinkConversationServiceImpl
implements RemoteLinkConversationService,
GreenHopperCache {
    @Autowired
    private UserManager userManager;
    @Autowired
    private CacheFactoryManager cacheFactoryManager;
    private Cache<String, RemoteLinkConversationService.CreationConversation> conversationsCache;

    @PostConstruct
    public void init() {
        this.conversationsCache = this.cacheFactoryManager.create().getCache(RemoteLinkConversationServiceImpl.class.getName() + ".conversationsCache", null, new CacheSettingsBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build());
    }

    @Override
    public ServiceOutcome<RemoteLinkConversationService.CreationConversation> startConversation(ApplicationUser user) {
        ApplicationUser applicationUser = this.userManager.getUserByName(user.getName());
        String token = UUID.randomUUID().toString();
        RemoteLinkConversationService.CreationConversation creationConversation = new RemoteLinkConversationService.CreationConversation(token, applicationUser.getKey(), RemoteLinkConversationService.CreationConversation.Status.PENDING);
        this.conversationsCache.put(token, creationConversation);
        return ServiceOutcomeImpl.ok(creationConversation);
    }

    @Override
    public ServiceOutcome<RemoteLinkConversationService.CreationConversation> redeemConversation(String token) {
        RemoteLinkConversationService.CreationConversation creationConversation = this.conversationsCache.get(token);
        if (creationConversation == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.remote.links.conversation.invalid.token", token);
        }
        if (creationConversation.getStatus() == RemoteLinkConversationService.CreationConversation.Status.REDEEMED) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.remote.links.conversation.redeemed.token", token);
        }
        RemoteLinkConversationService.CreationConversation conversation = new RemoteLinkConversationService.CreationConversation(token, creationConversation.getUserKey(), RemoteLinkConversationService.CreationConversation.Status.REDEEMED);
        this.conversationsCache.put(token, conversation);
        return ServiceOutcomeImpl.ok(conversation);
    }

    @Override
    public ServiceOutcome<RemoteLinkConversationService.CreationConversation> getConversation(String token) {
        RemoteLinkConversationService.CreationConversation creationConversation = this.conversationsCache.get(token);
        if (creationConversation == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.remote.links.conversation.invalid.token", token);
        }
        return ServiceOutcomeImpl.ok(creationConversation);
    }

    @Override
    public void flushCache() {
        this.conversationsCache.removeAll();
    }
}

