/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceResult;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ServiceResultImpl
implements ServiceResult {
    private static final ErrorCollection EMPTY_ERROR_COLLECTION = new ErrorCollection();
    private final ErrorCollection errors;

    private ServiceResultImpl() {
        this.errors = EMPTY_ERROR_COLLECTION;
    }

    private ServiceResultImpl(ErrorCollection errors) {
        this.errors = errors;
    }

    public static ServiceResult ok() {
        return new ServiceResultImpl();
    }

    public static ServiceResult error(ErrorCollection.Reason reason, String messageKey, Object ... params) {
        ErrorCollection errors = new ErrorCollection();
        errors.addError(reason, messageKey, params);
        return new ServiceResultImpl(errors);
    }

    public static ServiceResult validationError(String messageKey, String ... params) {
        return ServiceResultImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, messageKey, params);
    }

    public static ServiceResult error(String contextId, ErrorCollection.Reason reason, String messageKey, Object ... params) {
        ErrorCollection errors = new ErrorCollection();
        errors.addContextualError(reason, contextId, messageKey, params);
        return new ServiceResultImpl(errors);
    }

    public static ServiceResult from(ErrorCollection errors) {
        if (errors.hasErrors()) {
            return new ServiceResultImpl(errors);
        }
        return new ServiceResultImpl();
    }

    @Override
    public boolean isValid() {
        return !this.errors.hasErrors();
    }

    @Override
    public boolean isInvalid() {
        return !this.isValid();
    }

    @Override
    @Nonnull
    public ErrorCollection getErrors() {
        return this.errors;
    }
}

