/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.google.common.base.Function;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;

public class ServiceOutcomes {
    @Nonnull
    public static <T> Option<T> toOption(ServiceOutcome<T> outcome) {
        return outcome.isValid() ? Option.some(outcome.get()) : Option.none();
    }

    @Nonnull
    public static <T> Either<ErrorCollection, T> toEither(ServiceOutcome<T> outcome) {
        return outcome.isValid() ? Either.right(outcome.get()) : Either.left((Object)outcome.getErrors());
    }

    @Nonnull
    public static <T, A> ServiceOutcome<A> map(ServiceOutcome<T> outcome, Function<? super T, A> func) {
        return outcome.isValid() ? ServiceOutcomeImpl.ok(func.apply(outcome.getValue())) : ServiceOutcomeImpl.error(outcome);
    }

    @Nonnull
    public static <T, A> ServiceOutcome<A> flatMap(ServiceOutcome<T> outcome, Function<? super T, ServiceOutcome<A>> func) {
        return outcome.isValid() ? (ServiceOutcome)func.apply(outcome.getValue()) : ServiceOutcomeImpl.error(outcome);
    }
}

