/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service;

import com.atlassian.greenhopper.service.PersistenceService;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import com.thoughtworks.xstream.XStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="gh-persistenceService")
public class PersistenceServiceImpl
implements PersistenceService {
    private final Logger log = Logger.getLogger(this.getClass());
    private XStream xstream = new XStream();
    @Autowired
    private JiraPropertySetFactory jiraPropertySetFactory;

    @Override
    public void setLong(String entityName, Long entityId, String key, Long value) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        Validate.notNull((Object)key);
        Validate.notNull((Object)value);
        this.getPropertySet(entityName, entityId).setLong(key, value.longValue());
    }

    @Override
    public Long getLong(String entityName, Long entityId, String key) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        Validate.notNull((Object)key);
        PropertySet propertySet = this.getPropertySet(entityName, entityId);
        return this.exists(propertySet, key) ? Long.valueOf(propertySet.getLong(key)) : null;
    }

    @Override
    public void setDouble(String entityName, Long entityId, String key, Double value) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        Validate.notNull((Object)key);
        Validate.notNull((Object)value);
        this.getPropertySet(entityName, entityId).setDouble(key, value.doubleValue());
    }

    @Override
    public Double getDouble(String entityName, Long entityId, String key) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        Validate.notNull((Object)key);
        PropertySet propertySet = this.getPropertySet(entityName, entityId);
        return this.exists(propertySet, key) ? Double.valueOf(propertySet.getDouble(key)) : null;
    }

    @Override
    public void setBoolean(String entityName, Long entityId, String key, Boolean value) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        Validate.notNull((Object)key);
        Validate.notNull((Object)value);
        this.getPropertySet(entityName, entityId).setBoolean(key, value.booleanValue());
    }

    @Override
    public Boolean getBoolean(String entityName, Long entityId, String key) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        Validate.notNull((Object)key);
        PropertySet propertySet = this.getPropertySet(entityName, entityId);
        return this.exists(propertySet, key) ? Boolean.valueOf(propertySet.getBoolean(key)) : null;
    }

    @Override
    public void setString(@Nonnull String entityName, @Nonnull Long entityId, @Nonnull String key, @Nonnull String value) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        Validate.notNull((Object)key);
        Validate.notNull((Object)value);
        this.getPropertySet(entityName, entityId).setString(key, value);
    }

    @Override
    @Nullable
    public String getString(@Nonnull String entityName, @Nonnull Long entityId, @Nonnull String key) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        Validate.notNull((Object)key);
        PropertySet propertySet = this.getPropertySet(entityName, entityId);
        return this.exists(propertySet, key) ? propertySet.getString(key) : null;
    }

    @Override
    public Map<String, Object> getData(String entityName, Long entityId, String key) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        Validate.notNull((Object)key);
        String serializedData = this.getPropertySet(entityName, entityId).getText(key);
        if (serializedData == null) {
            return null;
        }
        return (Map)this.xstream.fromXML(serializedData);
    }

    @Override
    public void setData(String entityName, Long entityId, String key, Map<String, Object> data) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        Validate.notNull((Object)key);
        Validate.notNull(data);
        String serializedData = this.xstream.toXML(data);
        this.getPropertySet(entityName, entityId).setText(key, serializedData);
    }

    @Override
    public List<Object> getListData(String entityName, Long entityId, String key) {
        Validate.notNull((Object)entityName, (String)"entityName must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)entityId, (String)"entityId must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)key, (String)"key must not be null", (Object[])new Object[0]);
        String serializedData = this.getPropertySet(entityName, entityId).getText(key);
        if (serializedData == null) {
            return null;
        }
        return (List)this.xstream.fromXML(serializedData);
    }

    @Override
    public void setListData(String entityName, Long entityId, String key, List<Object> data) {
        Validate.notNull((Object)entityName, (String)"entityName must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)entityId, (String)"entityId must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)key, (String)"key must not be null", (Object[])new Object[0]);
        Validate.notNull(data, (String)"data must not be null", (Object[])new Object[0]);
        String serializedData = this.xstream.toXML(data);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Storing list data in property set: " + entityName + ":" + entityId + " => " + key + ":" + serializedData));
        }
        this.getPropertySet(entityName, entityId).setText(key, serializedData);
    }

    @Override
    public Set<String> getKeys(String entityName, Long entityId) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        Collection keys = this.getPropertySet(entityName, entityId).getKeys();
        if (keys.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> keySet = new HashSet<String>();
        for (String key : keys) {
            keySet.add(key);
        }
        return keySet;
    }

    @Override
    public boolean exists(String entityName, Long entityId, String key) {
        return this.exists(this.getPropertySet(entityName, entityId), key);
    }

    private boolean exists(PropertySet propertySet, String key) {
        return propertySet.exists(key);
    }

    @Override
    public Object getPropertyAsType(String entityName, Long entityId, String key) {
        PropertySet propertySet = this.getPropertySet(entityName, entityId);
        if (!this.exists(propertySet, key)) {
            return null;
        }
        return propertySet.getAsActualType(key);
    }

    @Override
    public void delete(String entityName, Long entityId, String key) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        Validate.notNull((Object)key);
        try {
            this.getPropertySet(entityName, entityId).remove(key);
        }
        catch (PropertyException e) {
            this.log.warn((Object)e, (Throwable)e);
        }
    }

    @Override
    public void deleteAll(String entityName, Long entityId) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        try {
            this.getPropertySet(entityName, entityId).remove();
        }
        catch (PropertyException e) {
            this.log.warn((Object)e, (Throwable)e);
        }
    }

    private PropertySet getPropertySet(String entityName, Long entityId) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        return this.jiraPropertySetFactory.buildCachingPropertySet(entityName, entityId);
    }
}

